import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyIpamPoolRequest, ModifyIpamPoolResult } from "../models/models_5";
export interface ModifyIpamPoolCommandInput extends ModifyIpamPoolRequest {
}
export interface ModifyIpamPoolCommandOutput extends ModifyIpamPoolResult, __MetadataBearer {
}

export declare class ModifyIpamPoolCommand extends $Command<ModifyIpamPoolCommandInput, ModifyIpamPoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyIpamPoolCommandInput;
    constructor(input: ModifyIpamPoolCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyIpamPoolCommandInput, ModifyIpamPoolCommandOutput>;
    private serialize;
    private deserialize;
}
