import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyHostsRequest, ModifyHostsResult } from "../models/models_5";
export interface ModifyHostsCommandInput extends ModifyHostsRequest {
}
export interface ModifyHostsCommandOutput extends ModifyHostsResult, __MetadataBearer {
}

export declare class ModifyHostsCommand extends $Command<ModifyHostsCommandInput, ModifyHostsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyHostsCommandInput;
    constructor(input: ModifyHostsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyHostsCommandInput, ModifyHostsCommandOutput>;
    private serialize;
    private deserialize;
}
