import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetPasswordDataRequest, GetPasswordDataResult } from "../models/models_5";
export interface GetPasswordDataCommandInput extends GetPasswordDataRequest {
}
export interface GetPasswordDataCommandOutput extends GetPasswordDataResult, __MetadataBearer {
}

export declare class GetPasswordDataCommand extends $Command<GetPasswordDataCommandInput, GetPasswordDataCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetPasswordDataCommandInput;
    constructor(input: GetPasswordDataCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetPasswordDataCommandInput, GetPasswordDataCommandOutput>;
    private serialize;
    private deserialize;
}
