import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamPoolAllocationsRequest, GetIpamPoolAllocationsResult } from "../models/models_4";
export interface GetIpamPoolAllocationsCommandInput extends GetIpamPoolAllocationsRequest {
}
export interface GetIpamPoolAllocationsCommandOutput extends GetIpamPoolAllocationsResult, __MetadataBearer {
}

export declare class GetIpamPoolAllocationsCommand extends $Command<GetIpamPoolAllocationsCommandInput, GetIpamPoolAllocationsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetIpamPoolAllocationsCommandInput;
    constructor(input: GetIpamPoolAllocationsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetIpamPoolAllocationsCommandInput, GetIpamPoolAllocationsCommandOutput>;
    private serialize;
    private deserialize;
}
