import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamAddressHistoryRequest, GetIpamAddressHistoryResult } from "../models/models_4";
export interface GetIpamAddressHistoryCommandInput extends GetIpamAddressHistoryRequest {
}
export interface GetIpamAddressHistoryCommandOutput extends GetIpamAddressHistoryResult, __MetadataBearer {
}

export declare class GetIpamAddressHistoryCommand extends $Command<GetIpamAddressHistoryCommandInput, GetIpamAddressHistoryCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetIpamAddressHistoryCommandInput;
    constructor(input: GetIpamAddressHistoryCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetIpamAddressHistoryCommandInput, GetIpamAddressHistoryCommandOutput>;
    private serialize;
    private deserialize;
}
