import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { VolumeAttachment } from "../models/models_0";
import { DetachVolumeRequest } from "../models/models_4";
export interface DetachVolumeCommandInput extends DetachVolumeRequest {
}
export interface DetachVolumeCommandOutput extends VolumeAttachment, __MetadataBearer {
}

export declare class DetachVolumeCommand extends $Command<DetachVolumeCommandInput, DetachVolumeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DetachVolumeCommandInput;
    constructor(input: DetachVolumeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DetachVolumeCommandInput, DetachVolumeCommandOutput>;
    private serialize;
    private deserialize;
}
