import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeVpcAttributeRequest, DescribeVpcAttributeResult } from "../models/models_4";
export interface DescribeVpcAttributeCommandInput extends DescribeVpcAttributeRequest {
}
export interface DescribeVpcAttributeCommandOutput extends DescribeVpcAttributeResult, __MetadataBearer {
}

export declare class DescribeVpcAttributeCommand extends $Command<DescribeVpcAttributeCommandInput, DescribeVpcAttributeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeVpcAttributeCommandInput;
    constructor(input: DescribeVpcAttributeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeVpcAttributeCommandInput, DescribeVpcAttributeCommandOutput>;
    private serialize;
    private deserialize;
}
