import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResponse } from "../models/models_4";
export interface DescribeSpotFleetRequestsCommandInput extends DescribeSpotFleetRequestsRequest {
}
export interface DescribeSpotFleetRequestsCommandOutput extends DescribeSpotFleetRequestsResponse, __MetadataBearer {
}

export declare class DescribeSpotFleetRequestsCommand extends $Command<DescribeSpotFleetRequestsCommandInput, DescribeSpotFleetRequestsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeSpotFleetRequestsCommandInput;
    constructor(input: DescribeSpotFleetRequestsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeSpotFleetRequestsCommandInput, DescribeSpotFleetRequestsCommandOutput>;
    private serialize;
    private deserialize;
}
