import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribePublicIpv4PoolsRequest, DescribePublicIpv4PoolsResult } from "../models/models_3";
export interface DescribePublicIpv4PoolsCommandInput extends DescribePublicIpv4PoolsRequest {
}
export interface DescribePublicIpv4PoolsCommandOutput extends DescribePublicIpv4PoolsResult, __MetadataBearer {
}

export declare class DescribePublicIpv4PoolsCommand extends $Command<DescribePublicIpv4PoolsCommandInput, DescribePublicIpv4PoolsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribePublicIpv4PoolsCommandInput;
    constructor(input: DescribePublicIpv4PoolsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribePublicIpv4PoolsCommandInput, DescribePublicIpv4PoolsCommandOutput>;
    private serialize;
    private deserialize;
}
