import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeImageAttributeRequest, ImageAttribute } from "../models/models_3";
export interface DescribeImageAttributeCommandInput extends DescribeImageAttributeRequest {
}
export interface DescribeImageAttributeCommandOutput extends ImageAttribute, __MetadataBearer {
}

export declare class DescribeImageAttributeCommand extends $Command<DescribeImageAttributeCommandInput, DescribeImageAttributeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeImageAttributeCommandInput;
    constructor(input: DescribeImageAttributeCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeImageAttributeCommandInput, DescribeImageAttributeCommandOutput>;
    private serialize;
    private deserialize;
}
