import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreatePlacementGroupRequest, CreatePlacementGroupResult } from "../models/models_1";
export interface CreatePlacementGroupCommandInput extends CreatePlacementGroupRequest {
}
export interface CreatePlacementGroupCommandOutput extends CreatePlacementGroupResult, __MetadataBearer {
}

export declare class CreatePlacementGroupCommand extends $Command<CreatePlacementGroupCommandInput, CreatePlacementGroupCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreatePlacementGroupCommandInput;
    constructor(input: CreatePlacementGroupCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreatePlacementGroupCommandInput, CreatePlacementGroupCommandOutput>;
    private serialize;
    private deserialize;
}
