import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateIpamRequest, CreateIpamResult } from "../models/models_1";
export interface CreateIpamCommandInput extends CreateIpamRequest {
}
export interface CreateIpamCommandOutput extends CreateIpamResult, __MetadataBearer {
}

export declare class CreateIpamCommand extends $Command<CreateIpamCommandInput, CreateIpamCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateIpamCommandInput;
    constructor(input: CreateIpamCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateIpamCommandInput, CreateIpamCommandOutput>;
    private serialize;
    private deserialize;
}
