import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateDhcpOptionsRequest, CreateDhcpOptionsResult } from "../models/models_0";
export interface CreateDhcpOptionsCommandInput extends CreateDhcpOptionsRequest {
}
export interface CreateDhcpOptionsCommandOutput extends CreateDhcpOptionsResult, __MetadataBearer {
}

export declare class CreateDhcpOptionsCommand extends $Command<CreateDhcpOptionsCommandInput, CreateDhcpOptionsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateDhcpOptionsCommandInput;
    constructor(input: CreateDhcpOptionsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateDhcpOptionsCommandInput, CreateDhcpOptionsCommandOutput>;
    private serialize;
    private deserialize;
}
