import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CancelImportTaskRequest, CancelImportTaskResult } from "../models/models_0";
export interface CancelImportTaskCommandInput extends CancelImportTaskRequest {
}
export interface CancelImportTaskCommandOutput extends CancelImportTaskResult, __MetadataBearer {
}

export declare class CancelImportTaskCommand extends $Command<CancelImportTaskCommandInput, CancelImportTaskCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CancelImportTaskCommandInput;
    constructor(input: CancelImportTaskCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CancelImportTaskCommandInput, CancelImportTaskCommandOutput>;
    private serialize;
    private deserialize;
}
