import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CancelCapacityReservationRequest, CancelCapacityReservationResult } from "../models/models_0";
export interface CancelCapacityReservationCommandInput extends CancelCapacityReservationRequest {
}
export interface CancelCapacityReservationCommandOutput extends CancelCapacityReservationResult, __MetadataBearer {
}

export declare class CancelCapacityReservationCommand extends $Command<CancelCapacityReservationCommandInput, CancelCapacityReservationCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CancelCapacityReservationCommandInput;
    constructor(input: CancelCapacityReservationCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CancelCapacityReservationCommandInput, CancelCapacityReservationCommandOutput>;
    private serialize;
    private deserialize;
}
