import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResult } from "../models/models_0";
export interface AssignPrivateIpAddressesCommandInput extends AssignPrivateIpAddressesRequest {
}
export interface AssignPrivateIpAddressesCommandOutput extends AssignPrivateIpAddressesResult, __MetadataBearer {
}

export declare class AssignPrivateIpAddressesCommand extends $Command<AssignPrivateIpAddressesCommandInput, AssignPrivateIpAddressesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AssignPrivateIpAddressesCommandInput;
    constructor(input: AssignPrivateIpAddressesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AssignPrivateIpAddressesCommandInput, AssignPrivateIpAddressesCommandOutput>;
    private serialize;
    private deserialize;
}
