import { _InstanceType, ActiveInstance, ActivityStatus, AllocationStrategy, AllowedPrincipal, AssociationStatus, BatchState, CapacityReservationState, CurrencyCodeValues, IamInstanceProfileAssociation, IamInstanceProfileSpecification, InstanceEventWindow, IpamPoolAllocation, IpPermission, ResourceType, SecurityGroupRule, Subnet, SubnetIpv6CidrBlockAssociation, Tag, TagSpecification, Tenancy, TransitGatewayAssociation, TransitGatewayAssociationState, TransitGatewayAttachmentResourceType, TransitGatewayAttachmentState, TransitGatewayMulticastDomainAssociations, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, TrunkInterfaceAssociation, UserIdGroupPair, Vpc, VpcCidrBlockAssociation, VpcIpv6CidrBlockAssociation, VpcPeeringConnection } from "./models_0";
import { BlockDeviceMapping, DiskImageFormat, FleetLaunchTemplateSpecification, FleetType, GroupIdentifier, InstanceInterruptionBehavior, InstanceIpv6Address, InstanceRequirements, InstanceRequirementsRequest, IpamResourceTag, Ipv4PrefixSpecificationRequest, Ipv6PrefixSpecificationRequest, PrivateIpAddressSpecification, RequestIpamResourceTag, RouteTable, Snapshot, SnapshotState, SpotDatafeedSubscription, SpotInstanceStateFault, SpotInstanceType, StorageTier, TargetCapacityUnitType, TrafficMirrorFilter, TrafficMirrorSession, TrafficMirrorTarget, TransitGateway, TransitGatewayConnect, VolumeType } from "./models_1";
import { ConnectionNotification, DnsEntry, DnsNameState, Filter, IpamPoolCidr, ServiceConfiguration, ServiceTypeDetail, State, TransitGatewayConnectPeer, TransitGatewayMulticastDomain, TransitGatewayRouteTable, Volume, VpcEndpoint, VpnConnection, VpnGateway } from "./models_2";
import { ArchitectureType, AttributeBooleanValue, EventInformation, ExportTaskS3Location, FastSnapshotRestoreStateCode, OfferingClassType, OfferingTypeValues, PaymentOption, PermissionGroup, ProductCode, RecurringCharge, ReservedInstancesModification, RIProductDescription, Scope, VirtualizationType } from "./models_3";
/**
 * <p>Contains the output of DescribeReservedInstancesModifications.</p>
 */
export interface DescribeReservedInstancesModificationsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when
     * 			there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The Reserved Instance modification information.</p>
     */
    ReservedInstancesModifications?: ReservedInstancesModification[];
}
export declare namespace DescribeReservedInstancesModificationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeReservedInstancesModificationsResult) => any;
}
/**
 * <p>Contains the parameters for DescribeReservedInstancesOfferings.</p>
 */
export interface DescribeReservedInstancesOfferingsRequest {
    /**
     * <p>The Availability Zone in which the Reserved Instance can be used.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be
     *           used.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>duration</code> - The duration of the Reserved Instance (for example, one year or
     *           three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>fixed-price</code> - The purchase price of the Reserved Instance (for example,
     *           9800.0).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The instance type that is covered by the
     *           reservation.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance
     *           Marketplace offerings. When this filter is not used, which is the default behavior, all
     *           offerings from both Amazon Web Services and the Reserved Instance Marketplace are listed.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>product-description</code> - The Reserved Instance product platform description.
     *           Instances that include <code>(Amazon VPC)</code> in the product platform description will
     *           only be displayed to EC2-Classic account holders and are for use with Amazon VPC.
     *             (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE
     *             Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise
     *             Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Red Hat
     *             Enterprise Linux with HA (Amazon VPC)</code> | <code>Windows</code> | <code>Windows
     *             (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with
     *             SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> |
     *             <code> Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server
     *             Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>) </p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>reserved-instances-offering-id</code> - The Reserved Instances offering
     *           ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or
     *             <code>Region</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for
     *           example, 0.84).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Include Reserved Instance Marketplace offerings in the response.</p>
     */
    IncludeMarketplace?: boolean;
    /**
     * <p>The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see
     *        <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *       <i>Amazon EC2 User Guide</i>.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>The maximum duration (in seconds) to filter when searching for offerings.</p>
     * 		       <p>Default: 94608000 (3 years)</p>
     */
    MaxDuration?: number;
    /**
     * <p>The maximum number of instances to filter when searching for offerings.</p>
     * 		       <p>Default: 20</p>
     */
    MaxInstanceCount?: number;
    /**
     * <p>The minimum duration (in seconds) to filter when searching for offerings.</p>
     * 		       <p>Default: 2592000 (1 month)</p>
     */
    MinDuration?: number;
    /**
     * <p>The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.</p>
     */
    OfferingClass?: OfferingClassType | string;
    /**
     * <p>The Reserved Instance product platform description. Instances that include <code>(Amazon
     *         VPC)</code> in the description are for use with Amazon VPC.</p>
     */
    ProductDescription?: RIProductDescription | string;
    /**
     * <p>One or more Reserved Instances offering IDs.</p>
     */
    ReservedInstancesOfferingIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy
     *       of <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware
     *       (i.e., Dedicated Instances).</p>
     *          <p>
     *             <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or <code>dedicated</code> values only.</p>
     *          <p>Default: <code>default</code>
     *          </p>
     */
    InstanceTenancy?: Tenancy | string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining
     * 			results of the initial request can be seen by sending another request with the returned
     * 				<code>NextToken</code> value. The maximum is 100.</p>
     * 		       <p>Default: 100</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API
     * 			version, you only have access to the <code>Medium Utilization</code> Reserved Instance
     * 			offering type. </p>
     */
    OfferingType?: OfferingTypeValues | string;
}
export declare namespace DescribeReservedInstancesOfferingsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeReservedInstancesOfferingsRequest) => any;
}
/**
 * <p>Describes a Reserved Instance offering.</p>
 */
export interface PricingDetail {
    /**
     * <p>The number of reservations available for the price.</p>
     */
    Count?: number;
    /**
     * <p>The price per instance.</p>
     */
    Price?: number;
}
export declare namespace PricingDetail {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PricingDetail) => any;
}
/**
 * <p>Describes a Reserved Instance offering.</p>
 */
export interface ReservedInstancesOffering {
    /**
     * <p>The Availability Zone in which the Reserved Instance can be used.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The duration of the Reserved Instance, in seconds.</p>
     */
    Duration?: number;
    /**
     * <p>The purchase price of the Reserved Instance.</p>
     */
    FixedPrice?: number;
    /**
     * <p>The instance type on which the Reserved Instance can be used.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>The Reserved Instance product platform description.</p>
     */
    ProductDescription?: RIProductDescription | string;
    /**
     * <p>The ID of the Reserved Instance offering. This is the offering ID used in <a>GetReservedInstancesExchangeQuote</a>
     *      to confirm that an exchange can be made.</p>
     */
    ReservedInstancesOfferingId?: string;
    /**
     * <p>The usage price of the Reserved Instance, per hour.</p>
     */
    UsagePrice?: number;
    /**
     * <p>The currency of the Reserved Instance offering you are purchasing. It's
     * 				specified using ISO 4217 standard currency codes. At this time,
     * 				the only supported currency is <code>USD</code>.</p>
     */
    CurrencyCode?: CurrencyCodeValues | string;
    /**
     * <p>The tenancy of the instance.</p>
     */
    InstanceTenancy?: Tenancy | string;
    /**
     * <p>Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or Amazon Web Services.
     *         If it's a Reserved Instance Marketplace offering, this is <code>true</code>.</p>
     */
    Marketplace?: boolean;
    /**
     * <p>If <code>convertible</code> it can be exchanged for Reserved Instances of
     *       the same or higher monetary value, with different configurations. If <code>standard</code>, it is not
     *       possible to perform an exchange.</p>
     */
    OfferingClass?: OfferingClassType | string;
    /**
     * <p>The Reserved Instance offering type.</p>
     */
    OfferingType?: OfferingTypeValues | string;
    /**
     * <p>The pricing details of the Reserved Instance offering.</p>
     */
    PricingDetails?: PricingDetail[];
    /**
     * <p>The recurring charge tag assigned to the resource.</p>
     */
    RecurringCharges?: RecurringCharge[];
    /**
     * <p>Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.</p>
     */
    Scope?: Scope | string;
}
export declare namespace ReservedInstancesOffering {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ReservedInstancesOffering) => any;
}
/**
 * <p>Contains the output of DescribeReservedInstancesOfferings.</p>
 */
export interface DescribeReservedInstancesOfferingsResult {
    /**
     * <p>A list of Reserved Instances offerings.</p>
     */
    ReservedInstancesOfferings?: ReservedInstancesOffering[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when
     * 			there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeReservedInstancesOfferingsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeReservedInstancesOfferingsResult) => any;
}
export interface DescribeRouteTablesRequest {
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     * 		             <p>
     *                   <code>association.route-table-association-id</code> - The ID of an association
     *                     ID for the route table.</p>
     * 		          </li>
     *             <li>
     * 		             <p>
     *                   <code>association.route-table-id</code> - The ID of the route table involved in
     *                     the association.</p>
     * 		          </li>
     *             <li>
     * 		             <p>
     *                   <code>association.subnet-id</code> - The ID of the subnet involved in the
     *                     association.</p>
     * 		          </li>
     *             <li>
     * 		             <p>
     *                   <code>association.main</code> - Indicates whether the route table is the main
     *                     route table for the VPC (<code>true</code> | <code>false</code>). Route tables
     *                     that do not have an association ID are not returned in the response.</p>
     * 		          </li>
     *             <li>
     * 		             <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the route table.</p>
     * 		          </li>
     *             <li>
     * 		             <p>
     *                   <code>route-table-id</code> - The ID of the route table.</p>
     * 		          </li>
     *             <li>
     * 				           <p>
     *                   <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a
     *                     route in the table.</p>
     * 			         </li>
     *             <li>
     *                   <p>
     *                   <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.</p>
     *                </li>
     *             <li>
     * 				           <p>
     *                   <code>route.destination-prefix-list-id</code> - The ID (prefix) of the Amazon Web Service
     *                     specified in a route in the table.</p>
     * 			         </li>
     *             <li>
     *                   <p>
     *                   <code>route.egress-only-internet-gateway-id</code> - The ID of an
     *                     egress-only Internet gateway specified in a route in the route table.</p>
     *                </li>
     *             <li>
     * 		             <p>
     *                   <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.</p>
     * 		          </li>
     *             <li>
     *                   <p>
     *                   <code>route.instance-id</code> - The ID of an instance specified in a route in the table.</p>
     *                </li>
     *             <li>
     *                   <p>
     *                   <code>route.nat-gateway-id</code> - The ID of a NAT gateway.</p>
     *                </li>
     *             <li>
     * 		             <p>
     *                   <code>route.transit-gateway-id</code> - The ID of a transit gateway.</p>
     * 		          </li>
     *             <li>
     * 		             <p>
     *                   <code>route.origin</code> - Describes how the route was created.
     *                         <code>CreateRouteTable</code> indicates that the route was automatically
     *                     created when the route table was created; <code>CreateRoute</code> indicates
     *                     that the route was manually added to the route table;
     *                         <code>EnableVgwRoutePropagation</code> indicates that the route was
     *                     propagated by route propagation.</p>
     * 		          </li>
     *             <li>
     *                   <p>
     *                   <code>route.state</code> - The state of a route in the route table
     *                         (<code>active</code> | <code>blackhole</code>). The blackhole state
     *                     indicates that the route's target isn't available (for example, the specified
     *                     gateway isn't attached to the VPC, the specified NAT instance has been
     *                     terminated, and so on).</p>
     *                </li>
     *             <li>
     * 		            <p>
     *                   <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering
     * 		                connection specified in a route in the table.</p>
     * 		          </li>
     *             <li>
     * 		            <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     * 		          </li>
     *             <li>
     * 		            <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     * 		          </li>
     *             <li>
     * 		            <p>
     *                   <code>vpc-id</code> - The ID of the VPC for the route table.</p>
     * 		          </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more route table IDs.</p>
     * 		       <p>Default: Describes all your route tables.</p>
     */
    RouteTableIds?: string[];
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeRouteTablesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeRouteTablesRequest) => any;
}
/**
 * <p>Contains the output of DescribeRouteTables.</p>
 */
export interface DescribeRouteTablesResult {
    /**
     * <p>Information about one or more route tables.</p>
     */
    RouteTables?: RouteTable[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeRouteTablesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeRouteTablesResult) => any;
}
/**
 * <p>Describes the time period for a Scheduled Instance to start its first schedule. The time period must span less than one day.</p>
 */
export interface SlotDateTimeRangeRequest {
    /**
     * <p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>
     */
    EarliestTime: Date | undefined;
    /**
     * <p>The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or equal to the earliest date and at most three months in the future.</p>
     */
    LatestTime: Date | undefined;
}
export declare namespace SlotDateTimeRangeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SlotDateTimeRangeRequest) => any;
}
/**
 * <p>Describes the recurring schedule for a Scheduled Instance.</p>
 */
export interface ScheduledInstanceRecurrenceRequest {
    /**
     * <p>The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).</p>
     */
    Frequency?: string;
    /**
     * <p>The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2
     *          weeks or every 2 months.</p>
     */
    Interval?: number;
    /**
     * <p>The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday). You can't specify this value with a daily schedule. If the occurrence is relative to the end of the month, you can specify only a single day.</p>
     */
    OccurrenceDays?: number[];
    /**
     * <p>Indicates whether the occurrence is relative to the end of the specified week or month. You can't specify this value with a daily schedule.</p>
     */
    OccurrenceRelativeToEnd?: boolean;
    /**
     * <p>The unit for <code>OccurrenceDays</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).
     *         This value is required for a monthly schedule.
     *         You can't specify <code>DayOfWeek</code> with a weekly schedule.
     *         You can't specify this value with a daily schedule.</p>
     */
    OccurrenceUnit?: string;
}
export declare namespace ScheduledInstanceRecurrenceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ScheduledInstanceRecurrenceRequest) => any;
}
/**
 * <p>Contains the parameters for DescribeScheduledInstanceAvailability.</p>
 */
export interface DescribeScheduledInstanceAvailabilityRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The time period for the first schedule to start.</p>
     */
    FirstSlotStartTimeRange: SlotDateTimeRangeRequest | undefined;
    /**
     * <p>The maximum number of results to return in a single call.
     *          This value can be between 5 and 300. The default value is 300.
     *          To retrieve the remaining results, make another call with the returned
     *          <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code>
     *          and less than 1,720.</p>
     */
    MaxSlotDurationInHours?: number;
    /**
     * <p>The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p>
     */
    MinSlotDurationInHours?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The schedule recurrence.</p>
     */
    Recurrence: ScheduledInstanceRecurrenceRequest | undefined;
}
export declare namespace DescribeScheduledInstanceAvailabilityRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeScheduledInstanceAvailabilityRequest) => any;
}
/**
 * <p>Describes the recurring schedule for a Scheduled Instance.</p>
 */
export interface ScheduledInstanceRecurrence {
    /**
     * <p>The frequency (<code>Daily</code>, <code>Weekly</code>, or <code>Monthly</code>).</p>
     */
    Frequency?: string;
    /**
     * <p>The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example, every 2
     *          weeks or every 2 months.</p>
     */
    Interval?: number;
    /**
     * <p>The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).</p>
     */
    OccurrenceDaySet?: number[];
    /**
     * <p>Indicates whether the occurrence is relative to the end of the specified week or month.</p>
     */
    OccurrenceRelativeToEnd?: boolean;
    /**
     * <p>The unit for <code>occurrenceDaySet</code> (<code>DayOfWeek</code> or <code>DayOfMonth</code>).</p>
     */
    OccurrenceUnit?: string;
}
export declare namespace ScheduledInstanceRecurrence {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ScheduledInstanceRecurrence) => any;
}
/**
 * <p>Describes a schedule that is available for your Scheduled Instances.</p>
 */
export interface ScheduledInstanceAvailability {
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of available instances.</p>
     */
    AvailableInstanceCount?: number;
    /**
     * <p>The time period for the first schedule to start.</p>
     */
    FirstSlotStartTime?: Date;
    /**
     * <p>The hourly price for a single instance.</p>
     */
    HourlyPrice?: string;
    /**
     * <p>The instance type. You can specify one of the C3, C4, M4, or R3 instance types.</p>
     */
    InstanceType?: string;
    /**
     * <p>The maximum term. The only possible value is 365 days.</p>
     */
    MaxTermDurationInDays?: number;
    /**
     * <p>The minimum term. The only possible value is 365 days.</p>
     */
    MinTermDurationInDays?: number;
    /**
     * <p>The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p>
     */
    NetworkPlatform?: string;
    /**
     * <p>The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p>
     */
    Platform?: string;
    /**
     * <p>The purchase token. This token expires in two hours.</p>
     */
    PurchaseToken?: string;
    /**
     * <p>The schedule recurrence.</p>
     */
    Recurrence?: ScheduledInstanceRecurrence;
    /**
     * <p>The number of hours in the schedule.</p>
     */
    SlotDurationInHours?: number;
    /**
     * <p>The total number of hours for a single instance for the entire term.</p>
     */
    TotalScheduledInstanceHours?: number;
}
export declare namespace ScheduledInstanceAvailability {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ScheduledInstanceAvailability) => any;
}
/**
 * <p>Contains the output of DescribeScheduledInstanceAvailability.</p>
 */
export interface DescribeScheduledInstanceAvailabilityResult {
    /**
     * <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the available Scheduled Instances.</p>
     */
    ScheduledInstanceAvailabilitySet?: ScheduledInstanceAvailability[];
}
export declare namespace DescribeScheduledInstanceAvailabilityResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeScheduledInstanceAvailabilityResult) => any;
}
/**
 * <p>Describes the time period for a Scheduled Instance to start its first schedule.</p>
 */
export interface SlotStartTimeRangeRequest {
    /**
     * <p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>
     */
    EarliestTime?: Date;
    /**
     * <p>The latest date and time, in UTC, for the Scheduled Instance to start.</p>
     */
    LatestTime?: Date;
}
export declare namespace SlotStartTimeRangeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SlotStartTimeRangeRequest) => any;
}
/**
 * <p>Contains the parameters for DescribeScheduledInstances.</p>
 */
export interface DescribeScheduledInstancesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return in a single call.
     *          This value can be between 5 and 300. The default value is 100.
     *          To retrieve the remaining results, make another call with the returned
     *          <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The Scheduled Instance IDs.</p>
     */
    ScheduledInstanceIds?: string[];
    /**
     * <p>The time period for the first schedule to start.</p>
     */
    SlotStartTimeRange?: SlotStartTimeRangeRequest;
}
export declare namespace DescribeScheduledInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeScheduledInstancesRequest) => any;
}
/**
 * <p>Describes a Scheduled Instance.</p>
 */
export interface ScheduledInstance {
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The date when the Scheduled Instance was purchased.</p>
     */
    CreateDate?: Date;
    /**
     * <p>The hourly price for a single instance.</p>
     */
    HourlyPrice?: string;
    /**
     * <p>The number of instances.</p>
     */
    InstanceCount?: number;
    /**
     * <p>The instance type.</p>
     */
    InstanceType?: string;
    /**
     * <p>The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p>
     */
    NetworkPlatform?: string;
    /**
     * <p>The time for the next schedule to start.</p>
     */
    NextSlotStartTime?: Date;
    /**
     * <p>The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p>
     */
    Platform?: string;
    /**
     * <p>The time that the previous schedule ended or will end.</p>
     */
    PreviousSlotEndTime?: Date;
    /**
     * <p>The schedule recurrence.</p>
     */
    Recurrence?: ScheduledInstanceRecurrence;
    /**
     * <p>The Scheduled Instance ID.</p>
     */
    ScheduledInstanceId?: string;
    /**
     * <p>The number of hours in the schedule.</p>
     */
    SlotDurationInHours?: number;
    /**
     * <p>The end date for the Scheduled Instance.</p>
     */
    TermEndDate?: Date;
    /**
     * <p>The start date for the Scheduled Instance.</p>
     */
    TermStartDate?: Date;
    /**
     * <p>The total number of hours for a single instance for the entire term.</p>
     */
    TotalScheduledInstanceHours?: number;
}
export declare namespace ScheduledInstance {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ScheduledInstance) => any;
}
/**
 * <p>Contains the output of DescribeScheduledInstances.</p>
 */
export interface DescribeScheduledInstancesResult {
    /**
     * <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the Scheduled Instances.</p>
     */
    ScheduledInstanceSet?: ScheduledInstance[];
}
export declare namespace DescribeScheduledInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeScheduledInstancesResult) => any;
}
export interface DescribeSecurityGroupReferencesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the security groups in your account.</p>
     */
    GroupId: string[] | undefined;
}
export declare namespace DescribeSecurityGroupReferencesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSecurityGroupReferencesRequest) => any;
}
/**
 * <p>Describes a VPC with a security group that references your security group.</p>
 */
export interface SecurityGroupReference {
    /**
     * <p>The ID of your security group.</p>
     */
    GroupId?: string;
    /**
     * <p>The ID of the VPC with the referencing security group.</p>
     */
    ReferencingVpcId?: string;
    /**
     * <p>The ID of the VPC peering connection.</p>
     */
    VpcPeeringConnectionId?: string;
}
export declare namespace SecurityGroupReference {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SecurityGroupReference) => any;
}
export interface DescribeSecurityGroupReferencesResult {
    /**
     * <p>Information about the VPCs with the referencing security groups.</p>
     */
    SecurityGroupReferenceSet?: SecurityGroupReference[];
}
export declare namespace DescribeSecurityGroupReferencesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSecurityGroupReferencesResult) => any;
}
export interface DescribeSecurityGroupRulesRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>group-id</code> - The ID of the security group.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>security-group-rule-id</code> - The ID of the security group rule.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The IDs of the security group rules.</p>
     */
    SecurityGroupRuleIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call. To retrieve the remaining
     *             results, make another request with the returned <code>NextToken</code> value. This value
     *             can be between 5 and 1000. If this parameter is not specified, then all results are
     *             returned.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeSecurityGroupRulesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSecurityGroupRulesRequest) => any;
}
export interface DescribeSecurityGroupRulesResult {
    /**
     * <p>Information about security group rules.</p>
     */
    SecurityGroupRules?: SecurityGroupRule[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
     */
    NextToken?: string;
}
export declare namespace DescribeSecurityGroupRulesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSecurityGroupRulesResult) => any;
}
export interface DescribeSecurityGroupsRequest {
    /**
     * <p>The filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>description</code> - The description of the security group.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound
     *                     security group rule.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.from-port</code> - For an outbound rule, the
     *                     start of port range for the TCP and UDP protocols, or an ICMP type
     *                     number.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.group-id</code> - The ID of a security group
     *                     that has been referenced in an outbound security group rule.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.group-name</code> - The name of a security group
     *                     that is referenced in an outbound security group rule.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an
     *                     outbound security group rule.</p>
     *             </li>
     *             <li>
     *      		        <p>
     *                   <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule allows outbound access.</p>
     *      	      </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.protocol</code> - The IP protocol for an
     *                     outbound security group rule (<code>tcp</code> | <code>udp</code> |
     *                         <code>icmp</code>, a protocol number, or -1 for all protocols).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.to-port</code> - For an outbound rule, the end
     *                     of port range for the TCP and UDP protocols, or an ICMP code.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>egress.ip-permission.user-id</code> - The ID of an Amazon Web Services account that
     *                     has been referenced in an outbound security group rule.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>group-id</code> - The ID of the security group. </p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>group-name</code> - The name of the security group.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security
     *                     group rule.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.from-port</code> - For an inbound rule, the start of port
     *                     range for the TCP and UDP protocols, or an ICMP type number.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.group-id</code> - The ID of a security group that has been
     *                     referenced in an inbound security group rule.</p>
     *             </li>
     *             <li>
     * 			            <p>
     *                   <code>ip-permission.group-name</code> - The name of a security group that is
     *                     referenced in an inbound security group rule.</p>
     * 	           </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security
     *                     group rule.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows inbound access.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.protocol</code> - The IP protocol for an inbound security
     *                 group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code>, a
     *                 protocol number, or -1 for all protocols).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.to-port</code> - For an inbound rule, the end of port range
     *                     for the TCP and UDP protocols, or an ICMP code.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-permission.user-id</code> - The ID of an Amazon Web Services account that has been
     *                     referenced in an inbound security group rule.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The Amazon Web Services account ID of the owner of the security group.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-id</code> - The ID of the VPC specified when the security group was created.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The IDs of the security groups. Required for security groups in a nondefault VPC.</p>
     *          <p>Default: Describes all of your security groups.</p>
     */
    GroupIds?: string[];
    /**
     * <p>[EC2-Classic and default VPC only] The names of the security groups. You can specify either
     * 			the security group name or the security group ID. For security groups in a nondefault VPC, use
     * 			the <code>group-name</code> filter to describe security groups by name.</p>
     *          <p>Default: Describes all of your security groups.</p>
     */
    GroupNames?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token to request the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call. To retrieve the remaining
     *             results, make another request with the returned <code>NextToken</code> value. This value
     *             can be between 5 and 1000. If this parameter is not specified, then all results are
     *             returned.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeSecurityGroupsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSecurityGroupsRequest) => any;
}
/**
 * <p>Describes a security group.</p>
 */
export interface SecurityGroup {
    /**
     * <p>A description of the security group.</p>
     */
    Description?: string;
    /**
     * <p>The name of the security group.</p>
     */
    GroupName?: string;
    /**
     * <p>The inbound rules associated with the security group.</p>
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The Amazon Web Services account ID of the owner of the security group.</p>
     */
    OwnerId?: string;
    /**
     * <p>The ID of the security group.</p>
     */
    GroupId?: string;
    /**
     * <p>[VPC only] The outbound rules associated with the security group.</p>
     */
    IpPermissionsEgress?: IpPermission[];
    /**
     * <p>Any tags assigned to the security group.</p>
     */
    Tags?: Tag[];
    /**
     * <p>[VPC only] The ID of the VPC for the security group.</p>
     */
    VpcId?: string;
}
export declare namespace SecurityGroup {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SecurityGroup) => any;
}
export interface DescribeSecurityGroupsResult {
    /**
     * <p>Information about the security groups.</p>
     */
    SecurityGroups?: SecurityGroup[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeSecurityGroupsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSecurityGroupsResult) => any;
}
export declare type SnapshotAttributeName = "createVolumePermission" | "productCodes";
export interface DescribeSnapshotAttributeRequest {
    /**
     * <p>The snapshot attribute you would like to view.</p>
     */
    Attribute: SnapshotAttributeName | string | undefined;
    /**
     * <p>The ID of the EBS snapshot.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeSnapshotAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSnapshotAttributeRequest) => any;
}
/**
 * <p>Describes the user or group to be added or removed from the list of create volume
 *       permissions for a volume.</p>
 */
export interface CreateVolumePermission {
    /**
     * <p>The group to be added or removed. The possible value is <code>all</code>.</p>
     */
    Group?: PermissionGroup | string;
    /**
     * <p>The ID of the Amazon Web Services account to be added or removed.</p>
     */
    UserId?: string;
}
export declare namespace CreateVolumePermission {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVolumePermission) => any;
}
export interface DescribeSnapshotAttributeResult {
    /**
     * <p>The users and groups that have the permissions for creating volumes from the
     *       snapshot.</p>
     */
    CreateVolumePermissions?: CreateVolumePermission[];
    /**
     * <p>The product codes.</p>
     */
    ProductCodes?: ProductCode[];
    /**
     * <p>The ID of the EBS snapshot.</p>
     */
    SnapshotId?: string;
}
export declare namespace DescribeSnapshotAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSnapshotAttributeResult) => any;
}
export interface DescribeSnapshotsRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>description</code> - A description of the snapshot.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>encrypted</code> - Indicates whether the snapshot is encrypted
     *             (<code>true</code> | <code>false</code>)</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-alias</code> - The owner alias, from an Amazon-maintained list
     *           (<code>amazon</code>).
     *           This is not the user-configured Amazon Web Services account alias set using the IAM console.
     *           We recommend that you use the related parameter instead of this filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that
     *           you use the related parameter instead of this filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>progress</code> - The progress of the snapshot, as a percentage (for example,
     *           80%).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>snapshot-id</code> - The snapshot ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>start-time</code> - The time stamp when the snapshot was initiated.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>status</code> - The status of the snapshot (<code>pending</code> |
     *             <code>completed</code> | <code>error</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> |
     *           <code>standard</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-id</code> - The ID of the volume the snapshot is for.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-size</code> - The size of the volume, in GiB.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in
     *       paginated output. When this parameter is used, <code>DescribeSnapshots</code> only returns
     *         <code>MaxResults</code> results in a single page along with a <code>NextToken</code>
     *       response element. The remaining results of the initial request can be seen by sending another
     *         <code>DescribeSnapshots</code> request with the returned <code>NextToken</code> value. This
     *       value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000,
     *       only 1,000 results are returned. If this parameter is not used, then
     *         <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and
     *       the snapshot IDs parameter in the same request.</p>
     */
    MaxResults?: number;
    /**
     * <p>The <code>NextToken</code> value returned from a previous paginated
     *         <code>DescribeSnapshots</code> request where <code>MaxResults</code> was used and the
     *       results exceeded the value of that parameter. Pagination continues from the end of the
     *       previous results that returned the <code>NextToken</code> value. This value is
     *         <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Scopes the results to snapshots with the specified owners. You can specify a combination of
     *       Amazon Web Services account IDs, <code>self</code>, and <code>amazon</code>.</p>
     */
    OwnerIds?: string[];
    /**
     * <p>The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.</p>
     */
    RestorableByUserIds?: string[];
    /**
     * <p>The snapshot IDs.</p>
     *          <p>Default: Describes the snapshots for which you have create volume permissions.</p>
     */
    SnapshotIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeSnapshotsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSnapshotsRequest) => any;
}
export interface DescribeSnapshotsResult {
    /**
     * <p>Information about the snapshots.</p>
     */
    Snapshots?: Snapshot[];
    /**
     * <p>The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code>
     *       request. When the results of a <code>DescribeSnapshots</code> request exceed
     *         <code>MaxResults</code>, this value can be used to retrieve the next page of results. This
     *       value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeSnapshotsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSnapshotsResult) => any;
}
export interface DescribeSnapshotTierStatusRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>snapshot-id</code> - The snapshot ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-id</code> - The ID of the volume the snapshot is for.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>last-tiering-operation</code> - The state of the last archive or restore action. (<code>archiving</code> | <code>archival_error</code> |
     *           <code>archival_complete</code> | <code>restoring</code> | <code>restore_error</code> | <code>restore_complete</code>)</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeSnapshotTierStatusRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSnapshotTierStatusRequest) => any;
}
export declare enum TieringOperationStatus {
    archival_completed = "archival-completed",
    archival_failed = "archival-failed",
    archival_in_progress = "archival-in-progress",
    permanent_restore_completed = "permanent-restore-completed",
    permanent_restore_failed = "permanent-restore-failed",
    permanent_restore_in_progress = "permanent-restore-in-progress",
    temporary_restore_completed = "temporary-restore-completed",
    temporary_restore_failed = "temporary-restore-failed",
    temporary_restore_in_progress = "temporary-restore-in-progress"
}
/**
 * <p>Provides information about a snapshot's storage tier.</p>
 */
export interface SnapshotTierStatus {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The ID of the volume from which the snapshot was created.</p>
     */
    VolumeId?: string;
    /**
     * <p>The state of the snapshot.</p>
     */
    Status?: SnapshotState | string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the snapshot.</p>
     */
    OwnerId?: string;
    /**
     * <p>The tags that are assigned to the snapshot.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The storage tier in which the snapshot is stored. <code>standard</code> indicates
     *       that the snapshot is stored in the standard snapshot storage tier and that it is ready
     *       for use. <code>archive</code> indicates that the snapshot is currently archived and that
     *       it must be restored before it can be used.</p>
     */
    StorageTier?: StorageTier | string;
    /**
     * <p>The date and time when the last archive or restore process was started.</p>
     */
    LastTieringStartTime?: Date;
    /**
     * <p>The progress of the last archive or restore process, as a percentage.</p>
     */
    LastTieringProgress?: number;
    /**
     * <p>The status of the last archive or restore process.</p>
     */
    LastTieringOperationStatus?: TieringOperationStatus | string;
    /**
     * <p>A message describing the status of the last archive or restore process.</p>
     */
    LastTieringOperationStatusDetail?: string;
    /**
     * <p>The date and time when the last archive process was completed.</p>
     */
    ArchivalCompleteTime?: Date;
    /**
     * <p>Only for archived snapshots that are temporarily restored. Indicates the date and
     *       time when a temporarily restored snapshot will be automatically re-archived.</p>
     */
    RestoreExpiryTime?: Date;
}
export declare namespace SnapshotTierStatus {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SnapshotTierStatus) => any;
}
export interface DescribeSnapshotTierStatusResult {
    /**
     * <p>Information about the snapshot's storage tier.</p>
     */
    SnapshotTierStatuses?: SnapshotTierStatus[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeSnapshotTierStatusResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSnapshotTierStatusResult) => any;
}
/**
 * <p>Contains the parameters for DescribeSpotDatafeedSubscription.</p>
 */
export interface DescribeSpotDatafeedSubscriptionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeSpotDatafeedSubscriptionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotDatafeedSubscriptionRequest) => any;
}
/**
 * <p>Contains the output of DescribeSpotDatafeedSubscription.</p>
 */
export interface DescribeSpotDatafeedSubscriptionResult {
    /**
     * <p>The Spot Instance data feed subscription.</p>
     */
    SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export declare namespace DescribeSpotDatafeedSubscriptionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotDatafeedSubscriptionResult) => any;
}
/**
 * <p>Contains the parameters for DescribeSpotFleetInstances.</p>
 */
export interface DescribeSpotFleetInstancesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 1
     *             and 1000. The default value is 1000. To retrieve the remaining results, make another
     *             call with the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId: string | undefined;
}
export declare namespace DescribeSpotFleetInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotFleetInstancesRequest) => any;
}
/**
 * <p>Contains the output of DescribeSpotFleetInstances.</p>
 */
export interface DescribeSpotFleetInstancesResponse {
    /**
     * <p>The running instances. This list is refreshed periodically and might be out of
     *             date.</p>
     */
    ActiveInstances?: ActiveInstance[];
    /**
     * <p>The token required to retrieve the next set of results. This value is
     *                 <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId?: string;
}
export declare namespace DescribeSpotFleetInstancesResponse {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotFleetInstancesResponse) => any;
}
export declare enum EventType {
    BATCH_CHANGE = "fleetRequestChange",
    ERROR = "error",
    INFORMATION = "information",
    INSTANCE_CHANGE = "instanceChange"
}
/**
 * <p>Contains the parameters for DescribeSpotFleetRequestHistory.</p>
 */
export interface DescribeSpotFleetRequestHistoryRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The type of events to describe. By default, all events are described.</p>
     */
    EventType?: EventType | string;
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 1
     *             and 1000. The default value is 1000. To retrieve the remaining results, make another
     *             call with the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId: string | undefined;
    /**
     * <p>The starting date and time for the events, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    StartTime: Date | undefined;
}
export declare namespace DescribeSpotFleetRequestHistoryRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestHistoryRequest) => any;
}
/**
 * <p>Describes an event in the history of the Spot Fleet request.</p>
 */
export interface HistoryRecord {
    /**
     * <p>Information about the event.</p>
     */
    EventInformation?: EventInformation;
    /**
     * <p>The event type.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>error</code> - An error with the Spot Fleet request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>fleetRequestChange</code> - A change in the status or configuration of
     *                     the Spot Fleet request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>instanceChange</code> - An instance was launched or terminated.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>Information</code> - An informational event.</p>
     *             </li>
     *          </ul>
     */
    EventType?: EventType | string;
    /**
     * <p>The date and time of the event, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    Timestamp?: Date;
}
export declare namespace HistoryRecord {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: HistoryRecord) => any;
}
/**
 * <p>Contains the output of DescribeSpotFleetRequestHistory.</p>
 */
export interface DescribeSpotFleetRequestHistoryResponse {
    /**
     * <p>Information about the events in the history of the Spot Fleet request.</p>
     */
    HistoryRecords?: HistoryRecord[];
    /**
     * <p>The last date and time for the events, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *             All records up to this time were retrieved.</p>
     *         <p>If <code>nextToken</code> indicates that there are more results, this value is not
     *             present.</p>
     */
    LastEvaluatedTime?: Date;
    /**
     * <p>The token required to retrieve the next set of results. This value is
     *                 <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId?: string;
    /**
     * <p>The starting date and time for the events, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    StartTime?: Date;
}
export declare namespace DescribeSpotFleetRequestHistoryResponse {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestHistoryResponse) => any;
}
/**
 * <p>Contains the parameters for DescribeSpotFleetRequests.</p>
 */
export interface DescribeSpotFleetRequestsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 1
     *             and 1000. The default value is 1000. To retrieve the remaining results, make another
     *             call with the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The IDs of the Spot Fleet requests.</p>
     */
    SpotFleetRequestIds?: string[];
}
export declare namespace DescribeSpotFleetRequestsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestsRequest) => any;
}
export declare enum ExcessCapacityTerminationPolicy {
    DEFAULT = "default",
    NO_TERMINATION = "noTermination"
}
/**
 * <p>Describes whether monitoring is enabled.</p>
 */
export interface SpotFleetMonitoring {
    /**
     * <p>Enables monitoring for the instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     */
    Enabled?: boolean;
}
export declare namespace SpotFleetMonitoring {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotFleetMonitoring) => any;
}
/**
 * <p>Describes a network interface.</p>
 */
export interface InstanceNetworkInterfaceSpecification {
    /**
     * <p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The
     *             public IP address can only be assigned to a network interface for eth0, and can only be
     *             assigned to a new network interface, not an existing one. You cannot specify more than one
     *             network interface in the request. If launching into a default subnet, the default value is
     *             <code>true</code>.</p>
     */
    AssociatePublicIpAddress?: boolean;
    /**
     * <p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can
     *             specify <code>true</code> only if creating a new network interface when launching an
     *             instance.</p>
     */
    DeleteOnTermination?: boolean;
    /**
     * <p>The description of the network interface. Applies only if creating a network interface when launching an instance.</p>
     */
    Description?: string;
    /**
     * <p>The position of the network interface in the attachment order.
     *           A primary network interface has a device index of 0.</p>
     *         <p>If you specify a network interface when launching an instance,
     *           you must specify the device index.</p>
     */
    DeviceIndex?: number;
    /**
     * <p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>
     */
    Groups?: string[];
    /**
     * <p>A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses
     *             the IPv6 addresses from the range of the subnet. You cannot specify this option and the
     *             option to assign specific IPv6 addresses in the same request. You can specify this
     *             option if you've specified a minimum number of instances to launch.</p>
     */
    Ipv6AddressCount?: number;
    /**
     * <p>One or more IPv6 addresses to assign to the network interface. You cannot specify
     *             this option and the option to assign a number of IPv6 addresses in the same request. You
     *             cannot specify this option if you've specified a minimum number of instances to
     *             launch.</p>
     */
    Ipv6Addresses?: InstanceIpv6Address[];
    /**
     * <p>The ID of the network interface.</p>
     *         <p>If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.</p>
     */
    NetworkInterfaceId?: string;
    /**
     * <p>The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching
     *         	more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
     */
    PrivateIpAddress?: string;
    /**
     * <p>One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're
     *         	launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
     */
    PrivateIpAddresses?: PrivateIpAddressSpecification[];
    /**
     * <p>The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're
     *         	launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
     */
    SecondaryPrivateIpAddressCount?: number;
    /**
     * <p>The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.</p>
     */
    SubnetId?: string;
    /**
     * <p>Indicates whether to assign a carrier IP address to the network interface.</p>
     *         <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone.
     *             For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.</p>
     */
    AssociateCarrierIpAddress?: boolean;
    /**
     * <p>The type of network interface.</p>
     * 	        <p>To create an Elastic Fabric Adapter (EFA), specify
     * 			<code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html">Elastic Fabric Adapter</a> in the
     * 			<i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *
     * 	        <p>Valid values: <code>interface</code> | <code>efa</code>
     *          </p>
     */
    InterfaceType?: string;
    /**
     * <p>The index of the network card. Some instance types support multiple network cards.
     *             The primary network interface must be assigned to network card index 0.
     *             The default is network card index 0.</p>
     *         <p>If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a> to create Spot Instances, omit this parameter because
     *             you can’t specify the network card index when using this API. To specify the network
     *             card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>
     */
    NetworkCardIndex?: number;
    /**
     * <p>One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot
     *             use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
     */
    Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
    /**
     * <p>The number of IPv4 delegated prefixes to be automatically assigned to the network interface.
     *             You cannot use this option if you use the <code>Ipv4Prefix</code> option.</p>
     */
    Ipv4PrefixCount?: number;
    /**
     * <p>One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot
     *             use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
     */
    Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
    /**
     * <p>The number of IPv6 delegated prefixes to be automatically assigned to the network interface.
     *             You cannot use this option if you use the <code>Ipv6Prefix</code> option.</p>
     */
    Ipv6PrefixCount?: number;
}
export declare namespace InstanceNetworkInterfaceSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceNetworkInterfaceSpecification) => any;
}
/**
 * <p>Describes Spot Instance placement.</p>
 */
export interface SpotPlacement {
    /**
     * <p>The Availability Zone.</p>
     *         <p>[Spot Fleet only] To specify multiple Availability Zones, separate them using commas;
     *             for example, "us-west-2a, us-west-2b".</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The name of the placement group.</p>
     */
    GroupName?: string;
    /**
     * <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a
     *             tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code>
     *             tenancy is not supported for Spot Instances.</p>
     */
    Tenancy?: Tenancy | string;
}
export declare namespace SpotPlacement {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotPlacement) => any;
}
/**
 * <p>The tags for a Spot Fleet resource.</p>
 */
export interface SpotFleetTagSpecification {
    /**
     * <p>The type of resource. Currently, the only resource type that is supported is
     *                 <code>instance</code>. To tag the Spot Fleet request on creation, use the
     *                 <code>TagSpecifications</code> parameter in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetRequestConfigData.html">
     *                <code>SpotFleetRequestConfigData</code>
     *             </a>.</p>
     */
    ResourceType?: ResourceType | string;
    /**
     * <p>The tags.</p>
     */
    Tags?: Tag[];
}
export declare namespace SpotFleetTagSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotFleetTagSpecification) => any;
}
/**
 * <p>Describes the launch specification for one or more Spot Instances. If you include
 *             On-Demand capacity in your fleet request or want to specify an EFA network device, you
 *             can't use <code>SpotFleetLaunchSpecification</code>; you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a>.</p>
 */
export interface SpotFleetLaunchSpecification {
    /**
     * <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
     */
    SecurityGroups?: GroupIdentifier[];
    /**
     * <p>Deprecated.</p>
     */
    AddressingType?: string;
    /**
     * <p>One or more block devices that are mapped to the Spot Instances. You can't specify both
     *             a snapshot ID and an encryption value. This is because only blank volumes can be
     *             encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its
     *             encryption status is used for the volume encryption status.</p>
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     */
    EbsOptimized?: boolean;
    /**
     * <p>The IAM instance profile.</p>
     */
    IamInstanceProfile?: IamInstanceProfileSpecification;
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId?: string;
    /**
     * <p>The instance type.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>The ID of the kernel.</p>
     */
    KernelId?: string;
    /**
     * <p>The name of the key pair.</p>
     */
    KeyName?: string;
    /**
     * <p>Enable or disable monitoring for the instances.</p>
     */
    Monitoring?: SpotFleetMonitoring;
    /**
     * <p>One or more network interfaces. If you specify a network interface, you must specify
     *           subnet IDs and security group IDs using the network interface.</p>
     *          <note>
     *             <p>
     *                <code>SpotFleetLaunchSpecification</code> currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a>.</p>
     *          </note>
     */
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    /**
     * <p>The placement information.</p>
     */
    Placement?: SpotPlacement;
    /**
     * <p>The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel
     *           requirements for information about whether you need to specify a RAM disk. To find kernel
     *           requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.</p>
     */
    RamdiskId?: string;
    /**
     * <p>The maximum price per unit hour that you are willing to pay for a Spot Instance.
     *           If this value is not specified, the default is the Spot price specified for the fleet.
     *           To determine the Spot price per unit hour, divide the Spot price by the
     *           value of <code>WeightedCapacity</code>.</p>
     */
    SpotPrice?: string;
    /**
     * <p>The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate
     *           them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".</p>
     */
    SubnetId?: string;
    /**
     * <p>The Base64-encoded user data that instances use when starting up.</p>
     */
    UserData?: string;
    /**
     * <p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.</p>
     *          <p>If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.</p>
     */
    WeightedCapacity?: number;
    /**
     * <p>The tags to apply during creation.</p>
     */
    TagSpecifications?: SpotFleetTagSpecification[];
    /**
     * <p>The attributes for the instance types. When you specify instance attributes, Amazon EC2 will
     *          identify instance types with those attributes.</p>
     *          <note>
     *             <p>If you specify <code>InstanceRequirements</code>, you can't specify
     *                <code>InstanceTypes</code>.</p>
     *          </note>
     */
    InstanceRequirements?: InstanceRequirements;
}
export declare namespace SpotFleetLaunchSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotFleetLaunchSpecification) => any;
}
/**
 * <p>Describes overrides for a launch template.</p>
 */
export interface LaunchTemplateOverrides {
    /**
     * <p>The instance type.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>The maximum price per unit hour that you are willing to pay for a Spot
     *             Instance.</p>
     */
    SpotPrice?: string;
    /**
     * <p>The ID of the subnet in which to launch the instances.</p>
     */
    SubnetId?: string;
    /**
     * <p>The Availability Zone in which to launch the instances.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of units provided by the specified instance type.</p>
     */
    WeightedCapacity?: number;
    /**
     * <p>The priority for the launch template override. The highest priority is launched
     *             first.</p>
     *         <p>If <code>OnDemandAllocationStrategy</code> is set to <code>prioritized</code>, Spot Fleet
     *             uses priority to determine which launch template override to use first in fulfilling
     *             On-Demand capacity.</p>
     *         <p>If the Spot <code>AllocationStrategy</code> is set to
     *                 <code>capacityOptimizedPrioritized</code>, Spot Fleet uses priority on a best-effort basis
     *             to determine which launch template override to use in fulfilling Spot capacity, but
     *             optimizes for capacity first.</p>
     *         <p>Valid values are whole numbers starting at <code>0</code>. The lower the number, the
     *             higher the priority. If no number is set, the launch template override has the lowest
     *             priority. You can set the same priority for different launch template overrides.</p>
     */
    Priority?: number;
    /**
     * <p>The instance requirements. When you specify instance requirements, Amazon EC2 will identify
     *          instance types with the provided requirements, and then use your On-Demand and Spot
     *          allocation strategies to launch instances from these instance types, in the same way as
     *          when you specify a list of instance types.</p>
     *          <note>
     *             <p>If you specify <code>InstanceRequirements</code>, you can't specify
     *                <code>InstanceTypes</code>.</p>
     *          </note>
     */
    InstanceRequirements?: InstanceRequirements;
}
export declare namespace LaunchTemplateOverrides {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LaunchTemplateOverrides) => any;
}
/**
 * <p>Describes a launch template and overrides.</p>
 */
export interface LaunchTemplateConfig {
    /**
     * <p>The launch template.</p>
     */
    LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
    /**
     * <p>Any parameters that you specify override the same parameters in the launch
     *             template.</p>
     */
    Overrides?: LaunchTemplateOverrides[];
}
export declare namespace LaunchTemplateConfig {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LaunchTemplateConfig) => any;
}
/**
 * <p>Describes a Classic Load Balancer.</p>
 */
export interface ClassicLoadBalancer {
    /**
     * <p>The name of the load balancer.</p>
     */
    Name?: string;
}
export declare namespace ClassicLoadBalancer {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClassicLoadBalancer) => any;
}
/**
 * <p>Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers
 *             the running Spot Instances with these Classic Load Balancers.</p>
 */
export interface ClassicLoadBalancersConfig {
    /**
     * <p>One or more Classic Load Balancers.</p>
     */
    ClassicLoadBalancers?: ClassicLoadBalancer[];
}
export declare namespace ClassicLoadBalancersConfig {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClassicLoadBalancersConfig) => any;
}
/**
 * <p>Describes a load balancer target group.</p>
 */
export interface TargetGroup {
    /**
     * <p>The Amazon Resource Name (ARN) of the target group.</p>
     */
    Arn?: string;
}
export declare namespace TargetGroup {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TargetGroup) => any;
}
/**
 * <p>Describes the target groups to attach to a Spot Fleet. Spot Fleet registers the
 *             running Spot Instances with these target groups.</p>
 */
export interface TargetGroupsConfig {
    /**
     * <p>One or more target groups.</p>
     */
    TargetGroups?: TargetGroup[];
}
export declare namespace TargetGroupsConfig {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TargetGroupsConfig) => any;
}
/**
 * <p>Describes the Classic Load Balancers and target groups to attach to a Spot Fleet
 *             request.</p>
 */
export interface LoadBalancersConfig {
    /**
     * <p>The Classic Load Balancers.</p>
     */
    ClassicLoadBalancersConfig?: ClassicLoadBalancersConfig;
    /**
     * <p>The target groups.</p>
     */
    TargetGroupsConfig?: TargetGroupsConfig;
}
export declare namespace LoadBalancersConfig {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LoadBalancersConfig) => any;
}
export declare enum OnDemandAllocationStrategy {
    LOWEST_PRICE = "lowestPrice",
    PRIORITIZED = "prioritized"
}
export declare enum ReplacementStrategy {
    LAUNCH = "launch",
    LAUNCH_BEFORE_TERMINATE = "launch-before-terminate"
}
/**
 * <p>The Spot Instance replacement strategy to use when Amazon EC2 emits a signal that your
 *             Spot Instance is at an elevated risk of being interrupted. For more information, see
 *                 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#spot-fleet-capacity-rebalance">Capacity rebalancing</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
 */
export interface SpotCapacityRebalance {
    /**
     * <p>The replacement strategy to use. Only available for fleets of type
     *             <code>maintain</code>.</p>
     *         <p>
     *             <code>launch</code> - Spot Fleet launches a new replacement Spot Instance when a
     *             rebalance notification is emitted for an existing Spot Instance in the fleet. Spot Fleet
     *             does not terminate the instances that receive a rebalance notification. You can
     *             terminate the old instances, or you can leave them running. You are charged for all
     *             instances while they are running. </p>
     *         <p>
     *             <code>launch-before-terminate</code> - Spot Fleet launches a new replacement Spot
     *             Instance when a rebalance notification is emitted for an existing Spot Instance in the
     *             fleet, and then, after a delay that you specify (in <code>TerminationDelay</code>),
     *             terminates the instances that received a rebalance notification.</p>
     */
    ReplacementStrategy?: ReplacementStrategy | string;
    /**
     * <p>The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot
     *             Instance after launching a new replacement Spot Instance.</p>
     *         <p>Valid only when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code>.</p>
     *         <p>Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.</p>
     */
    TerminationDelay?: number;
}
export declare namespace SpotCapacityRebalance {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotCapacityRebalance) => any;
}
/**
 * <p>The strategies for managing your Spot Instances that are at an elevated risk of being
 *             interrupted.</p>
 */
export interface SpotMaintenanceStrategies {
    /**
     * <p>The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an
     *             elevated risk of being interrupted.</p>
     */
    CapacityRebalance?: SpotCapacityRebalance;
}
export declare namespace SpotMaintenanceStrategies {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotMaintenanceStrategies) => any;
}
/**
 * <p>Describes the configuration of a Spot Fleet request.</p>
 */
export interface SpotFleetRequestConfigData {
    /**
     * <p>Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by
     *             the Spot Fleet request.</p>
     *         <p>If the allocation strategy is <code>lowestPrice</code>, Spot Fleet launches instances from
     *             the Spot Instance pools with the lowest price. This is the default allocation strategy.</p>
     *         <p>If the allocation strategy is <code>diversified</code>, Spot Fleet launches instances from
     *             all the Spot Instance pools that you specify.</p>
     *         <p>If the allocation strategy is <code>capacityOptimized</code> (recommended), Spot Fleet
     *             launches instances from Spot Instance pools with optimal capacity for the number of instances
     *             that are launching. To give certain instance types a higher chance of launching first,
     *             use <code>capacityOptimizedPrioritized</code>. Set a priority for each instance type by
     *             using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You
     *             can assign the same priority to different <code>LaunchTemplateOverrides</code>. EC2
     *             implements the priorities on a best-effort basis, but optimizes for capacity first.
     *                 <code>capacityOptimizedPrioritized</code> is supported only if your Spot Fleet uses a
     *             launch template. Note that if the <code>OnDemandAllocationStrategy</code> is set to
     *                 <code>prioritized</code>, the same priority is applied when fulfilling On-Demand
     *             capacity.</p>
     */
    AllocationStrategy?: AllocationStrategy | string;
    /**
     * <p>The order of the launch template overrides to use in fulfilling On-Demand capacity. If
     *             you specify <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching
     *             the lowest price first. If you specify <code>prioritized</code>, Spot Fleet uses the priority
     *             that you assign to each Spot Fleet launch template override, launching the highest priority
     *             first. If you do not specify a value, Spot Fleet defaults to <code>lowestPrice</code>.</p>
     */
    OnDemandAllocationStrategy?: OnDemandAllocationStrategy | string;
    /**
     * <p>The strategies for managing your Spot Instances that are at an elevated risk of being
     *             interrupted.</p>
     */
    SpotMaintenanceStrategies?: SpotMaintenanceStrategies;
    /**
     * <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of your
     *             listings. This helps to avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>Indicates whether running Spot Instances should be terminated if you decrease the
     *             target capacity of the Spot Fleet request below the current size of the Spot
     *             Fleet.</p>
     */
    ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | string;
    /**
     * <p>The number of units fulfilled by this request compared to the set target capacity. You
     *             cannot set this value.</p>
     */
    FulfilledCapacity?: number;
    /**
     * <p>The number of On-Demand units fulfilled by this request compared to the set target
     *             On-Demand capacity.</p>
     */
    OnDemandFulfilledCapacity?: number;
    /**
     * <p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that
     *             grants the Spot Fleet the permission to request, launch, terminate, and tag instances on
     *             your behalf. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html#spot-fleet-prerequisites">Spot
     *                 Fleet prerequisites</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>. Spot Fleet
     *             can terminate Spot Instances on your behalf when you cancel its Spot Fleet request using
     *                 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests">CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
     *                 <code>TerminateInstancesWithExpiration</code>.</p>
     */
    IamFleetRole: string | undefined;
    /**
     * <p>The launch specifications for the Spot Fleet request. If you specify
     *                 <code>LaunchSpecifications</code>, you can't specify
     *                 <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your
     *             request, you must use <code>LaunchTemplateConfigs</code>.</p>
     */
    LaunchSpecifications?: SpotFleetLaunchSpecification[];
    /**
     * <p>The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>,
     *             you can't specify <code>LaunchSpecifications</code>. If you include On-Demand capacity
     *             in your request, you must use <code>LaunchTemplateConfigs</code>.</p>
     */
    LaunchTemplateConfigs?: LaunchTemplateConfig[];
    /**
     * <p>The maximum price per unit hour that you are willing to pay for a Spot Instance. The
     *             default is the On-Demand price.</p>
     */
    SpotPrice?: string;
    /**
     * <p>The number of units to request for the Spot Fleet. You can choose to set the target
     *             capacity in terms of instances or a performance characteristic that is important to your
     *             application workload, such as vCPUs, memory, or I/O. If the request type is
     *                 <code>maintain</code>, you can specify a target capacity of 0 and add capacity
     *             later.</p>
     */
    TargetCapacity: number | undefined;
    /**
     * <p>The number of On-Demand units to request. You can choose to set the target capacity in
     *             terms of instances or a performance characteristic that is important to your application
     *             workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code>,
     *             you can specify a target capacity of 0 and add capacity later.</p>
     */
    OnDemandTargetCapacity?: number;
    /**
     * <p>The maximum amount per hour for On-Demand Instances that you're willing to pay. You
     *             can use the <code>onDemandMaxTotalPrice</code> parameter, the
     *                 <code>spotMaxTotalPrice</code> parameter, or both parameters to ensure that your
     *             fleet cost does not exceed your budget. If you set a maximum price per hour for the
     *             On-Demand Instances and Spot Instances in your request, Spot Fleet will launch instances until it reaches the
     *             maximum amount you're willing to pay. When the maximum amount you're willing to pay is
     *             reached, the fleet stops launching instances even if it hasn’t met the target
     *             capacity.</p>
     */
    OnDemandMaxTotalPrice?: string;
    /**
     * <p>The maximum amount per hour for Spot Instances that you're willing to pay. You can use
     *             the <code>spotdMaxTotalPrice</code> parameter, the <code>onDemandMaxTotalPrice</code>
     *             parameter, or both parameters to ensure that your fleet cost does not exceed your
     *             budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request,
     *             Spot Fleet will launch instances until it reaches the maximum amount you're willing to pay.
     *             When the maximum amount you're willing to pay is reached, the fleet stops launching
     *             instances even if it hasn’t met the target capacity.</p>
     */
    SpotMaxTotalPrice?: string;
    /**
     * <p>Indicates whether running Spot Instances are terminated when the Spot Fleet request
     *             expires.</p>
     */
    TerminateInstancesWithExpiration?: boolean;
    /**
     * <p>The type of request. Indicates whether the Spot Fleet only requests the target
     *             capacity or also attempts to maintain it. When this value is <code>request</code>, the
     *             Spot Fleet only places the required requests. It does not attempt to replenish Spot
     *             Instances if capacity is diminished, nor does it submit requests in alternative Spot
     *             pools if capacity is not available. When this value is <code>maintain</code>, the Spot
     *             Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
     *             capacity and automatically replenishes any interrupted instances. Default:
     *                 <code>maintain</code>. <code>instant</code> is listed but is not used by Spot
     *             Fleet.</p>
     */
    Type?: FleetType | string;
    /**
     * <p>The start date and time of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *             By default, Amazon EC2 starts fulfilling the request immediately.</p>
     */
    ValidFrom?: Date;
    /**
     * <p>The end date and time of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *             After the end date and time, no new Spot Instance requests are placed or able to fulfill
     *             the request. If no value is specified, the Spot Fleet request remains until you cancel
     *             it.</p>
     */
    ValidUntil?: Date;
    /**
     * <p>Indicates whether Spot Fleet should replace unhealthy instances.</p>
     */
    ReplaceUnhealthyInstances?: boolean;
    /**
     * <p>The behavior when a Spot Instance is interrupted. The default is
     *                 <code>terminate</code>.</p>
     */
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
    /**
     * <p>One or more Classic Load Balancers and target groups to attach to the Spot Fleet
     *             request. Spot Fleet registers the running Spot Instances with the specified Classic Load
     *             Balancers and target groups.</p>
     *         <p>With Network Load Balancers, Spot Fleet cannot register instances that have the
     *             following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2,
     *             M3, and T1.</p>
     */
    LoadBalancersConfig?: LoadBalancersConfig;
    /**
     * <p>The number of Spot pools across which to allocate your target Spot capacity. Valid
     *             only when Spot <b>AllocationStrategy</b> is set to
     *                 <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools and evenly
     *             allocates your target Spot capacity across the number of Spot pools that you
     *             specify.</p>
     *         <p>Note that Spot Fleet attempts to draw Spot Instances from the number of pools that you specify on a
     *             best effort basis. If a pool runs out of Spot capacity before fulfilling your target
     *             capacity, Spot Fleet will continue to fulfill your request by drawing from the next cheapest
     *             pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
     *             the number of pools that you specified. Similarly, if most of the pools have no Spot
     *             capacity, you might receive your full target capacity from fewer than the number of
     *             pools that you specified.</p>
     */
    InstancePoolsToUseCount?: number;
    /**
     * <p>Reserved.</p>
     */
    Context?: string;
    /**
     * <p>The unit for the target capacity.</p>
     *          <p>Default: <code>units</code> (translates to number of instances)</p>
     */
    TargetCapacityUnitType?: TargetCapacityUnitType | string;
    /**
     * <p>The key-value pair for tagging the Spot Fleet request on creation. The value for
     *                 <code>ResourceType</code> must be <code>spot-fleet-request</code>, otherwise the
     *             Spot Fleet request fails. To tag instances at launch, specify the tags in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch
     *                 template</a> (valid only if you use <code>LaunchTemplateConfigs</code>) or in
     *             the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetTagSpecification.html">
     *                <code>SpotFleetTagSpecification</code>
     *             </a> (valid only if you use
     *                 <code>LaunchSpecifications</code>). For information about tagging after launch, see
     *                 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging Your Resources</a>.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace SpotFleetRequestConfigData {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotFleetRequestConfigData) => any;
}
/**
 * <p>Describes a Spot Fleet request.</p>
 */
export interface SpotFleetRequestConfig {
    /**
     * <p>The progress of the Spot Fleet request.
     *           If there is an error, the status is <code>error</code>.
     *           After all requests are placed, the status is <code>pending_fulfillment</code>.
     *           If the size of the fleet is equal to or greater than its target capacity, the status is <code>fulfilled</code>.
     *           If the size of the fleet is decreased, the status is <code>pending_termination</code>
     *           while Spot Instances are terminating.</p>
     */
    ActivityStatus?: ActivityStatus | string;
    /**
     * <p>The creation date and time of the request.</p>
     */
    CreateTime?: Date;
    /**
     * <p>The configuration of the Spot Fleet request.</p>
     */
    SpotFleetRequestConfig?: SpotFleetRequestConfigData;
    /**
     * <p>The ID of the Spot Fleet request.</p>
     */
    SpotFleetRequestId?: string;
    /**
     * <p>The state of the Spot Fleet request.</p>
     */
    SpotFleetRequestState?: BatchState | string;
    /**
     * <p>The tags for a Spot Fleet resource.</p>
     */
    Tags?: Tag[];
}
export declare namespace SpotFleetRequestConfig {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotFleetRequestConfig) => any;
}
/**
 * <p>Contains the output of DescribeSpotFleetRequests.</p>
 */
export interface DescribeSpotFleetRequestsResponse {
    /**
     * <p>The token required to retrieve the next set of results. This value is
     *                 <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the configuration of your Spot Fleet.</p>
     */
    SpotFleetRequestConfigs?: SpotFleetRequestConfig[];
}
export declare namespace DescribeSpotFleetRequestsResponse {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestsResponse) => any;
}
/**
 * <p>Contains the parameters for DescribeSpotInstanceRequests.</p>
 */
export interface DescribeSpotInstanceRequestsRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>availability-zone-group</code> - The Availability Zone group.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>create-time</code> - The time stamp when the Spot Instance request was
     *                     created.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>fault-code</code> - The fault code related to the request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>fault-message</code> - The fault message related to the request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>instance-id</code> - The ID of the instance that fulfilled the
     *                     request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch-group</code> - The Spot Instance launch group.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.block-device-mapping.delete-on-termination</code> - Indicates
     *                     whether the EBS volume is deleted on instance termination.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.block-device-mapping.device-name</code> - The device name for the
     *                     volume in the block device mapping (for example, <code>/dev/sdh</code> or
     *                         <code>xvdh</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot
     *                     for the EBS volume.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.block-device-mapping.volume-size</code> - The size of the EBS
     *                     volume, in GiB.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume:
     *                         <code>gp2</code> for General Purpose SSD, <code>io1</code> or
     *                         <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput
     *                     Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for
     *                     Magnetic.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.group-id</code> - The ID of the security group for the
     *                     instance.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.group-name</code> - The name of the security group for the
     *                     instance.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.image-id</code> - The ID of the AMI.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.instance-type</code> - The type of instance (for example,
     *                         <code>m3.medium</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.kernel-id</code> - The kernel ID.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.key-name</code> - The name of the key pair the instance launched
     *                     with.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.monitoring-enabled</code> - Whether detailed monitoring is
     *                     enabled for the Spot Instance.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launch.ramdisk-id</code> - The RAM disk ID.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>launched-availability-zone</code> - The Availability Zone in which the
     *                     request is launched.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.addresses.primary</code> - Indicates whether the IP
     *                     address is the primary private IP address.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.delete-on-termination</code> - Indicates whether the
     *                     network interface is deleted when the instance is terminated.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.description</code> - A description of the network
     *                     interface.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.device-index</code> - The index of the device for the
     *                     network interface attachment on the instance.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.group-id</code> - The ID of the security group
     *                     associated with the network interface.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.network-interface-id</code> - The ID of the network
     *                     interface.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.private-ip-address</code> - The primary private IP
     *                     address of the network interface.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>network-interface.subnet-id</code> - The ID of the subnet for the
     *                     instance.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>product-description</code> - The product description associated with the
     *                     instance (<code>Linux/UNIX</code> | <code>Windows</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>spot-instance-request-id</code> - The Spot Instance request ID.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>spot-price</code> - The maximum hourly price for any Spot Instance
     *                     launched to fulfill the request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the Spot Instance request (<code>open</code>
     *                     | <code>active</code> | <code>closed</code> | <code>cancelled</code> |
     *                         <code>failed</code>). Spot request status information can help you track
     *                     your Amazon EC2 Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot
     *                         request status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>status-code</code> - The short code describing the most recent
     *                     evaluation of your Spot Instance request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>status-message</code> - The message explaining the status of the Spot
     *                     Instance request.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag:<key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>type</code> - The type of Spot Instance request (<code>one-time</code> |
     *                         <code>persistent</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>valid-from</code> - The start date of the request.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>valid-until</code> - The end date of the request.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more Spot Instance request IDs.</p>
     */
    SpotInstanceRequestIds?: string[];
    /**
     * <p>The token to request the next set of results. This value is <code>null</code> when
     *             there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 5
     *             and 1000. To retrieve the remaining results, make another call with the returned
     *                 <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeSpotInstanceRequestsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotInstanceRequestsRequest) => any;
}
/**
 * <p>Describes the monitoring of an instance.</p>
 */
export interface RunInstancesMonitoringEnabled {
    /**
     * <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is
     *             enabled.</p>
     */
    Enabled: boolean | undefined;
}
export declare namespace RunInstancesMonitoringEnabled {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: RunInstancesMonitoringEnabled) => any;
}
/**
 * <p>Describes the launch specification for an instance.</p>
 */
export interface LaunchSpecification {
    /**
     * <p>The Base64-encoded user data for the instance.</p>
     */
    UserData?: string;
    /**
     * <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
     */
    SecurityGroups?: GroupIdentifier[];
    /**
     * <p>Deprecated.</p>
     */
    AddressingType?: string;
    /**
     * <p>One or more block device mapping entries.</p>
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     */
    EbsOptimized?: boolean;
    /**
     * <p>The IAM instance profile.</p>
     */
    IamInstanceProfile?: IamInstanceProfileSpecification;
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId?: string;
    /**
     * <p>The instance type.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>The ID of the kernel.</p>
     */
    KernelId?: string;
    /**
     * <p>The name of the key pair.</p>
     */
    KeyName?: string;
    /**
     * <p>One or more network interfaces. If you specify a network interface, you must specify
     *            subnet IDs and security group IDs using the network interface.</p>
     */
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    /**
     * <p>The placement information for the instance.</p>
     */
    Placement?: SpotPlacement;
    /**
     * <p>The ID of the RAM disk.</p>
     */
    RamdiskId?: string;
    /**
     * <p>The ID of the subnet in which to launch the instance.</p>
     */
    SubnetId?: string;
    /**
     * <p>Describes the monitoring of an instance.</p>
     */
    Monitoring?: RunInstancesMonitoringEnabled;
}
export declare namespace LaunchSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LaunchSpecification) => any;
}
export declare type SpotInstanceState = "active" | "cancelled" | "closed" | "failed" | "open";
/**
 * <p>Describes the status of a Spot Instance request.</p>
 */
export interface SpotInstanceStatus {
    /**
     * <p>The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     */
    Code?: string;
    /**
     * <p>The description for the status code.</p>
     */
    Message?: string;
    /**
     * <p>The date and time of the most recent status update, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    UpdateTime?: Date;
}
export declare namespace SpotInstanceStatus {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotInstanceStatus) => any;
}
/**
 * <p>Describes a Spot Instance request.</p>
 */
export interface SpotInstanceRequest {
    /**
     * <p>Deprecated.</p>
     */
    ActualBlockHourlyPrice?: string;
    /**
     * <p>The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.</p>
     */
    AvailabilityZoneGroup?: string;
    /**
     * <p>Deprecated.</p>
     */
    BlockDurationMinutes?: number;
    /**
     * <p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    CreateTime?: Date;
    /**
     * <p>The fault codes for the Spot Instance request, if any.</p>
     */
    Fault?: SpotInstanceStateFault;
    /**
     * <p>The instance ID, if an instance has been launched to fulfill the Spot Instance request.</p>
     */
    InstanceId?: string;
    /**
     * <p>The instance launch group. Launch groups are Spot Instances that launch together and terminate together.</p>
     */
    LaunchGroup?: string;
    /**
     * <p>Additional information for launching instances.</p>
     */
    LaunchSpecification?: LaunchSpecification;
    /**
     * <p>The Availability Zone in which the request is launched.</p>
     */
    LaunchedAvailabilityZone?: string;
    /**
     * <p>The product description associated with the Spot Instance.</p>
     */
    ProductDescription?: RIProductDescription | string;
    /**
     * <p>The ID of the Spot Instance request.</p>
     */
    SpotInstanceRequestId?: string;
    /**
     * <p>The maximum price per hour that you are willing to pay for a Spot Instance.</p>
     */
    SpotPrice?: string;
    /**
     * <p>The state of the Spot Instance request. Spot status information helps track your Spot
     *             Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status</a> in the
     *                 <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     */
    State?: SpotInstanceState | string;
    /**
     * <p>The status code and status message describing the Spot Instance request.</p>
     */
    Status?: SpotInstanceStatus;
    /**
     * <p>Any tags assigned to the resource.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The Spot Instance request type.</p>
     */
    Type?: SpotInstanceType | string;
    /**
     * <p>The start date of the request, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *             The request becomes active at this date and time.</p>
     */
    ValidFrom?: Date;
    /**
     * <p>The end date of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     *          <ul>
     *             <li>
     *                 <p>For a persistent request, the request remains active until the <code>validUntil</code> date
     *                     and time is reached. Otherwise, the request remains active until you cancel it.
     *                 </p>
     *             </li>
     *             <li>
     *                <p>For a one-time request, the request remains active until all instances launch,
     *                     the request is canceled, or the <code>validUntil</code> date and time is reached. By default, the
     *                     request is valid for 7 days from the date the request was created.</p>
     *            </li>
     *          </ul>
     */
    ValidUntil?: Date;
    /**
     * <p>The behavior when a Spot Instance is interrupted.</p>
     */
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace SpotInstanceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotInstanceRequest) => any;
}
/**
 * <p>Contains the output of DescribeSpotInstanceRequests.</p>
 */
export interface DescribeSpotInstanceRequestsResult {
    /**
     * <p>One or more Spot Instance requests.</p>
     */
    SpotInstanceRequests?: SpotInstanceRequest[];
    /**
     * <p>The token to use to retrieve the next set of results. This value is <code>null</code>
     *             when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeSpotInstanceRequestsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotInstanceRequestsResult) => any;
}
/**
 * <p>Contains the parameters for DescribeSpotPriceHistory.</p>
 */
export interface DescribeSpotPriceHistoryRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                     <code>availability-zone</code> - The Availability Zone for which prices should
     *                     be returned.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>instance-type</code> - The type of instance (for example,
     *                         <code>m3.medium</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>product-description</code> - The product description for the Spot price
     *                         (<code>Linux/UNIX</code> | <code>Red Hat Enterprise Linux</code> |
     *                         <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon
     *                         VPC)</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> |
     *                         <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon
     *                     VPC)</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>spot-price</code> - The Spot price. The value must match exactly (or use
     *                     wildcards; greater than or less than comparison is not supported).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>timestamp</code> - The time stamp of the Spot price history, in UTC format
     *                     (for example,
     *                         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *                     You can use wildcards (* and ?). Greater than or less than comparison is not
     *                     supported.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Filters the results by the specified Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The date and time, up to the current date, from which to stop retrieving the price
     *             history data, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    EndTime?: Date;
    /**
     * <p>Filters the results by the specified instance types.</p>
     */
    InstanceTypes?: (_InstanceType | string)[];
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 1
     *             and 1000. The default value is 1000. To retrieve the remaining results, make another
     *             call with the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Filters the results by the specified basic product descriptions.</p>
     */
    ProductDescriptions?: string[];
    /**
     * <p>The date and time, up to the past 90 days, from which to start retrieving the price
     *             history data, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    StartTime?: Date;
}
export declare namespace DescribeSpotPriceHistoryRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotPriceHistoryRequest) => any;
}
/**
 * <p>Describes the maximum price per hour that you are willing to pay for a Spot
 *             Instance.</p>
 */
export interface SpotPrice {
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The instance type.</p>
     */
    InstanceType?: _InstanceType | string;
    /**
     * <p>A general description of the AMI.</p>
     */
    ProductDescription?: RIProductDescription | string;
    /**
     * <p>The maximum price per hour that you are willing to pay for a Spot Instance.</p>
     */
    SpotPrice?: string;
    /**
     * <p>The date and time the request was created, in UTC format (for example,
     *                 <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     */
    Timestamp?: Date;
}
export declare namespace SpotPrice {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SpotPrice) => any;
}
/**
 * <p>Contains the output of DescribeSpotPriceHistory.</p>
 */
export interface DescribeSpotPriceHistoryResult {
    /**
     * <p>The token required to retrieve the next set of results. This value is null or an empty
     *             string when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The historical Spot prices.</p>
     */
    SpotPriceHistory?: SpotPrice[];
}
export declare namespace DescribeSpotPriceHistoryResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSpotPriceHistoryResult) => any;
}
export interface DescribeStaleSecurityGroupsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of items to return. (You received this token from a prior call.)</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
}
export declare namespace DescribeStaleSecurityGroupsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeStaleSecurityGroupsRequest) => any;
}
/**
 * <p>Describes a stale rule in a security group.</p>
 */
export interface StaleIpPermission {
    /**
     * <p>The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     *         <code>-1</code> indicates all ICMP types. </p>
     */
    FromPort?: number;
    /**
     * <p>The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number  (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.</p>
     */
    IpProtocol?: string;
    /**
     * <p>The IP ranges. Not applicable for stale security group rules.</p>
     */
    IpRanges?: string[];
    /**
     * <p>The prefix list IDs. Not applicable for stale security group rules.</p>
     */
    PrefixListIds?: string[];
    /**
     * <p>The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     *         <code>-1</code> indicates all ICMP types. </p>
     */
    ToPort?: number;
    /**
     * <p>The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the VPC peering connection.</p>
     */
    UserIdGroupPairs?: UserIdGroupPair[];
}
export declare namespace StaleIpPermission {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: StaleIpPermission) => any;
}
/**
 * <p>Describes a stale security group (a security group that contains stale rules).</p>
 */
export interface StaleSecurityGroup {
    /**
     * <p>The description of the security group.</p>
     */
    Description?: string;
    /**
     * <p>The ID of the security group.</p>
     */
    GroupId?: string;
    /**
     * <p>The name of the security group.</p>
     */
    GroupName?: string;
    /**
     * <p>Information about the stale inbound rules in the security group.</p>
     */
    StaleIpPermissions?: StaleIpPermission[];
    /**
     * <p>Information about the stale outbound rules in the security group.</p>
     */
    StaleIpPermissionsEgress?: StaleIpPermission[];
    /**
     * <p>The ID of the VPC for the security group.</p>
     */
    VpcId?: string;
}
export declare namespace StaleSecurityGroup {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: StaleSecurityGroup) => any;
}
export interface DescribeStaleSecurityGroupsResult {
    /**
     * <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the stale security groups.</p>
     */
    StaleSecurityGroupSet?: StaleSecurityGroup[];
}
export declare namespace DescribeStaleSecurityGroupsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeStaleSecurityGroupsResult) => any;
}
export interface DescribeStoreImageTasksRequest {
    /**
     * <p>The AMI IDs for which to show progress. Up to 20 AMI IDs can be included in a request.</p>
     */
    ImageIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *       and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *       Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>task-state</code> - Returns tasks in a certain state (<code>InProgress</code> |
     *             <code>Completed</code> | <code>Failed</code>)</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>bucket</code> - Returns task information for tasks that targeted a specific
     *           bucket. For the filter value, specify the bucket name.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call. To retrieve the remaining
     *       results, make another call with the returned <code>NextToken</code> value. This value can be
     *       between 1 and 200. You cannot specify this parameter and the <code>ImageIDs</code> parameter
     *       in the same call.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeStoreImageTasksRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeStoreImageTasksRequest) => any;
}
/**
 * <p>The information about the AMI store task, including the progress of the task.</p>
 */
export interface StoreImageTaskResult {
    /**
     * <p>The ID of the AMI that is being stored.</p>
     */
    AmiId?: string;
    /**
     * <p>The time the task started.</p>
     */
    TaskStartTime?: Date;
    /**
     * <p>The name of the Amazon S3 bucket that contains the stored AMI object.</p>
     */
    Bucket?: string;
    /**
     * <p>The name of the stored AMI object in the bucket.</p>
     */
    S3objectKey?: string;
    /**
     * <p>The progress of the task as a percentage.</p>
     */
    ProgressPercentage?: number;
    /**
     * <p>The state of the store task (<code>InProgress</code>, <code>Completed</code>, or
     *         <code>Failed</code>).</p>
     */
    StoreTaskState?: string;
    /**
     * <p>If the tasks fails, the reason for the failure is returned. If the task succeeds,
     *         <code>null</code> is returned.</p>
     */
    StoreTaskFailureReason?: string;
}
export declare namespace StoreImageTaskResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: StoreImageTaskResult) => any;
}
export interface DescribeStoreImageTasksResult {
    /**
     * <p>The information about the AMI store tasks.</p>
     */
    StoreImageTaskResults?: StoreImageTaskResult[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code>
     *       when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeStoreImageTasksResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeStoreImageTasksResult) => any;
}
export interface DescribeSubnetsRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>availability-zone</code> - The Availability Zone for the subnet. You can also use
     *                     <code>availabilityZone</code> as the filter name.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet.
     *                     You can also use <code>availabilityZoneId</code> as the filter name.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>available-ip-address-count</code> - The number of IPv4 addresses in the
     *                     subnet that are available.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you
     *                     specify must exactly match the subnet's CIDR block for information to be
     *                     returned for the subnet. You can also use <code>cidr</code> or
     *                     <code>cidrBlock</code> as the filter names.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>default-for-az</code> - Indicates whether this is the default subnet for the
     *                     Availability Zone (<code>true</code> | <code>false</code>). You can also use
     *                     <code>defaultForAz</code> as the filter name.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR
     *                     block associated with the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.association-id</code> - An association ID
     *                     for an IPv6 CIDR block associated with the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR
     *                     block associated with the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> | <code>false</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>subnet-id</code> - The ID of the subnet.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpc-id</code> - The ID of the VPC for the subnet.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>One or more subnet IDs.</p>
     * 		       <p>Default: Describes all your subnets.</p>
     */
    SubnetIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeSubnetsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSubnetsRequest) => any;
}
export interface DescribeSubnetsResult {
    /**
     * <p>Information about one or more subnets.</p>
     */
    Subnets?: Subnet[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeSubnetsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeSubnetsResult) => any;
}
export interface DescribeTagsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>key</code> - The tag key.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-id</code> - The ID of the resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> | <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> | <code>host-reservation</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>key-pair</code> | <code>launch-template</code> | <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> | <code>placement-group</code> | <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-endpoint</code> | <code>vpc-endpoint-service</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of the tag. For example,
     *                 specify "tag:Owner" for the filter name and "TeamA" for the filter value to find
     *                 resources with the tag "Owner=TeamA".</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>value</code> - The tag value.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return in a single call.
     *       This value can be between 5 and 1000.
     * 			To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTagsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTagsRequest) => any;
}
/**
 * <p>Describes a tag.</p>
 */
export interface TagDescription {
    /**
     * <p>The tag key.</p>
     */
    Key?: string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The resource type.</p>
     */
    ResourceType?: ResourceType | string;
    /**
     * <p>The tag value.</p>
     */
    Value?: string;
}
export declare namespace TagDescription {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TagDescription) => any;
}
export interface DescribeTagsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is
     *          <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The tags.</p>
     */
    Tags?: TagDescription[];
}
export declare namespace DescribeTagsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTagsResult) => any;
}
export interface DescribeTrafficMirrorFiltersRequest {
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     */
    TrafficMirrorFilterIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>description</code>: The Traffic Mirror filter description.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>traffic-mirror-filter-id</code>: The ID of the Traffic Mirror filter.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorFiltersRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrafficMirrorFiltersRequest) => any;
}
export interface DescribeTrafficMirrorFiltersResult {
    /**
     * <p>Information about one or more Traffic Mirror filters.</p>
     */
    TrafficMirrorFilters?: TrafficMirrorFilter[];
    /**
     * <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorFiltersResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrafficMirrorFiltersResult) => any;
}
export interface DescribeTrafficMirrorSessionsRequest {
    /**
     * <p>The ID of the Traffic Mirror session.</p>
     */
    TrafficMirrorSessionIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>description</code>: The Traffic Mirror session description.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-interface-id</code>: The ID of the Traffic Mirror session network interface.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code>: The ID of the account that owns the Traffic Mirror session.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>packet-length</code>: The assigned number of packets to mirror. </p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>session-number</code>: The assigned session number. </p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>traffic-mirror-filter-id</code>: The ID of the Traffic Mirror filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>traffic-mirror-session-id</code>: The ID of the Traffic Mirror session.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>traffic-mirror-target-id</code>: The ID of the Traffic Mirror target.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>virtual-network-id</code>: The virtual network ID of the Traffic Mirror session.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorSessionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrafficMirrorSessionsRequest) => any;
}
export interface DescribeTrafficMirrorSessionsResult {
    /**
     * <p>Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.</p>
     */
    TrafficMirrorSessions?: TrafficMirrorSession[];
    /**
     * <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorSessionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrafficMirrorSessionsResult) => any;
}
export interface DescribeTrafficMirrorTargetsRequest {
    /**
     * <p>The ID of the Traffic Mirror targets.</p>
     */
    TrafficMirrorTargetIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>description</code>: The Traffic Mirror target description.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-interface-id</code>: The ID of the Traffic Mirror session network interface.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-load-balancer-arn</code>: The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the session.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code>: The ID of the account that owns the Traffic Mirror session.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>traffic-mirror-target-id</code>: The ID of the Traffic Mirror target.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorTargetsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrafficMirrorTargetsRequest) => any;
}
export interface DescribeTrafficMirrorTargetsResult {
    /**
     * <p>Information about one or more Traffic Mirror targets.</p>
     */
    TrafficMirrorTargets?: TrafficMirrorTarget[];
    /**
     * <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorTargetsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrafficMirrorTargetsResult) => any;
}
export interface DescribeTransitGatewayAttachmentsRequest {
    /**
     * <p>The IDs of the attachments.</p>
     */
    TransitGatewayAttachmentIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>association.state</code> - The state of the association (<code>associating</code> | <code>associated</code> |
     *                <code>disassociating</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>association.transit-gateway-route-table-id</code> - The ID of the route table for the transit gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-id</code> - The ID of the resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-owner-id</code> - The ID of the Amazon Web Services account that owns the resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-type</code> - The resource type. Valid values are <code>vpc</code>
     *                     | <code>vpn</code> | <code>direct-connect-gateway</code> | <code>peering</code>
     *                     | <code>connect</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the attachment. Valid values are <code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> |  <code>failing</code> | <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-owner-id</code> - The ID of the Amazon Web Services account that owns the transit gateway.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayAttachmentsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayAttachmentsRequest) => any;
}
/**
 * <p>Describes an association.</p>
 */
export interface TransitGatewayAttachmentAssociation {
    /**
     * <p>The ID of the route table for the transit gateway.</p>
     */
    TransitGatewayRouteTableId?: string;
    /**
     * <p>The state of the association.</p>
     */
    State?: TransitGatewayAssociationState | string;
}
export declare namespace TransitGatewayAttachmentAssociation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayAttachmentAssociation) => any;
}
/**
 * <p>Describes an attachment between a resource and a transit gateway.</p>
 */
export interface TransitGatewayAttachment {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the transit gateway.</p>
     */
    TransitGatewayOwnerId?: string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the resource.</p>
     */
    ResourceOwnerId?: string;
    /**
     * <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.</p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The attachment state. Note that the <code>initiating</code> state has been deprecated.</p>
     */
    State?: TransitGatewayAttachmentState | string;
    /**
     * <p>The association.</p>
     */
    Association?: TransitGatewayAttachmentAssociation;
    /**
     * <p>The creation time.</p>
     */
    CreationTime?: Date;
    /**
     * <p>The tags for the attachment.</p>
     */
    Tags?: Tag[];
}
export declare namespace TransitGatewayAttachment {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayAttachment) => any;
}
export interface DescribeTransitGatewayAttachmentsResult {
    /**
     * <p>Information about the attachments.</p>
     */
    TransitGatewayAttachments?: TransitGatewayAttachment[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayAttachmentsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayAttachmentsResult) => any;
}
export interface DescribeTransitGatewayConnectPeersRequest {
    /**
     * <p>The IDs of the Connect peers.</p>
     */
    TransitGatewayConnectPeerIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *         <ul>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the Connect peer (<code>pending</code> |
     *                         <code>available</code> | <code>deleting</code> |
     *                     <code>deleted</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-connect-peer-id</code> - The ID of the Connect peer.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayConnectPeersRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectPeersRequest) => any;
}
export interface DescribeTransitGatewayConnectPeersResult {
    /**
     * <p>Information about the Connect peers.</p>
     */
    TransitGatewayConnectPeers?: TransitGatewayConnectPeer[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayConnectPeersResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectPeersResult) => any;
}
export interface DescribeTransitGatewayConnectsRequest {
    /**
     * <p>The IDs of the attachments.</p>
     */
    TransitGatewayAttachmentIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *         <ul>
     *             <li>
     *                <p>
     *                   <code>options.protocol</code> - The tunnel protocol (<code>gre</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the attachment (<code>initiating</code> |
     *                         <code>initiatingRequest</code> | <code>pendingAcceptance</code> |
     *                         <code>rollingBack</code> | <code>pending</code> | <code>available</code> |
     *                         <code>modifying</code> | <code>deleting</code> | <code>deleted</code> |
     *                         <code>failed</code> | <code>rejected</code> | <code>rejecting</code> |
     *                         <code>failing</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the
     *                     Connect attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transport-transit-gateway-attachment-id</code> - The ID of the transit gateway attachment from which the Connect attachment was created.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayConnectsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectsRequest) => any;
}
export interface DescribeTransitGatewayConnectsResult {
    /**
     * <p>Information about the Connect attachments.</p>
     */
    TransitGatewayConnects?: TransitGatewayConnect[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayConnectsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectsResult) => any;
}
export interface DescribeTransitGatewayMulticastDomainsRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the transit gateway multicast domain. Valid values are <code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-multicast-domain-id</code> - The ID of the transit gateway multicast domain.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayMulticastDomainsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayMulticastDomainsRequest) => any;
}
export interface DescribeTransitGatewayMulticastDomainsResult {
    /**
     * <p>Information about the transit gateway multicast domains.</p>
     */
    TransitGatewayMulticastDomains?: TransitGatewayMulticastDomain[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayMulticastDomainsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayMulticastDomainsResult) => any;
}
export interface DescribeTransitGatewayPeeringAttachmentsRequest {
    /**
     * <p>One or more IDs of the transit gateway peering attachments.</p>
     */
    TransitGatewayAttachmentIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the transit gateway attachment.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>local-owner-id</code> - The ID of your Amazon Web Services account.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>remote-owner-id</code> - The ID of the Amazon Web Services account in the remote Region that owns the transit gateway.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the peering attachment. Valid values are <code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> |  <code>failing</code> | <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayPeeringAttachmentsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayPeeringAttachmentsRequest) => any;
}
export interface DescribeTransitGatewayPeeringAttachmentsResult {
    /**
     * <p>The transit gateway peering attachments.</p>
     */
    TransitGatewayPeeringAttachments?: TransitGatewayPeeringAttachment[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayPeeringAttachmentsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayPeeringAttachmentsResult) => any;
}
export interface DescribeTransitGatewayRouteTablesRequest {
    /**
     * <p>The IDs of the transit gateway route tables.</p>
     */
    TransitGatewayRouteTableIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>default-association-route-table</code> - Indicates whether this is the default
     *                 association route table for the transit gateway (<code>true</code> | <code>false</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>default-propagation-route-table</code> - Indicates whether this is the default
     *                propagation route table for the transit gateway (<code>true</code> | <code>false</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> | <code>deleted</code> | <code>pending</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayRouteTablesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayRouteTablesRequest) => any;
}
export interface DescribeTransitGatewayRouteTablesResult {
    /**
     * <p>Information about the transit gateway route tables.</p>
     */
    TransitGatewayRouteTables?: TransitGatewayRouteTable[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayRouteTablesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayRouteTablesResult) => any;
}
export interface DescribeTransitGatewaysRequest {
    /**
     * <p>The IDs of the transit gateways.</p>
     */
    TransitGatewayIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>options.propagation-default-route-table-id</code> - The ID of the default propagation route table.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.amazon-side-asn</code> - The private ASN for the Amazon side of a BGP session.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.association-default-route-table-id</code> - The ID of the default association route table.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.auto-accept-shared-attachments</code> - Indicates whether there is automatic acceptance of attachment requests (<code>enable</code> | <code>disable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.default-route-table-association</code> - Indicates whether resource attachments are automatically
     *                associated with the default association route table (<code>enable</code> | <code>disable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.default-route-table-propagation</code> - Indicates whether resource attachments automatically propagate
     *                routes to the default propagation route table (<code>enable</code> | <code>disable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.dns-support</code> - Indicates whether DNS support is enabled (<code>enable</code> | <code>disable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>options.vpn-ecmp-support</code> - Indicates whether Equal Cost Multipath Protocol support is enabled  (<code>enable</code> | <code>disable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the transit gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the transit gateway (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>modifying</code> | <code>pending</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewaysRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewaysRequest) => any;
}
export interface DescribeTransitGatewaysResult {
    /**
     * <p>Information about the transit gateways.</p>
     */
    TransitGateways?: TransitGateway[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewaysResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewaysResult) => any;
}
export interface DescribeTransitGatewayVpcAttachmentsRequest {
    /**
     * <p>The IDs of the attachments.</p>
     */
    TransitGatewayAttachmentIds?: string[];
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the attachment. Valid values are <code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> |  <code>failing</code> | <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-id</code> - The ID of the transit gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-id</code> - The ID of the VPC.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayVpcAttachmentsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayVpcAttachmentsRequest) => any;
}
export interface DescribeTransitGatewayVpcAttachmentsResult {
    /**
     * <p>Information about the VPC attachments.</p>
     */
    TransitGatewayVpcAttachments?: TransitGatewayVpcAttachment[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayVpcAttachmentsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTransitGatewayVpcAttachmentsResult) => any;
}
export interface DescribeTrunkInterfaceAssociationsRequest {
    /**
     * <p>The IDs of the associations.</p>
     */
    AssociationIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>gre-key</code> - The ID of a trunk interface association.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>interface-protocol</code> - The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     *             To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeTrunkInterfaceAssociationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrunkInterfaceAssociationsRequest) => any;
}
export interface DescribeTrunkInterfaceAssociationsResult {
    /**
     * <p>Information about the trunk associations.</p>
     */
    InterfaceAssociations?: TrunkInterfaceAssociation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeTrunkInterfaceAssociationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeTrunkInterfaceAssociationsResult) => any;
}
export declare type VolumeAttributeName = "autoEnableIO" | "productCodes";
export interface DescribeVolumeAttributeRequest {
    /**
     * <p>The attribute of the volume. This parameter is required.</p>
     */
    Attribute: VolumeAttributeName | string | undefined;
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeVolumeAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumeAttributeRequest) => any;
}
export interface DescribeVolumeAttributeResult {
    /**
     * <p>The state of <code>autoEnableIO</code> attribute.</p>
     */
    AutoEnableIO?: AttributeBooleanValue;
    /**
     * <p>A list of product codes.</p>
     */
    ProductCodes?: ProductCode[];
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId?: string;
}
export declare namespace DescribeVolumeAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumeAttributeResult) => any;
}
export interface DescribeVolumesRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>attachment.attach-time</code> - The time stamp when the attachment
     *           initiated.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.delete-on-termination</code> - Whether the volume is deleted on
     *           instance termination.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.device</code> - The device name specified in the block device mapping
     *           (for example, <code>/dev/sda1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.instance-id</code> - The ID of the instance the volume is attached
     *           to.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.status</code> - The attachment state (<code>attaching</code> |
     *             <code>attached</code> | <code>detaching</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone in which the volume was
     *           created.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>create-time</code> - The time stamp when the volume was created.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>encrypted</code> - Indicates whether the volume is encrypted (<code>true</code>
     *           | <code>false</code>)</p>
     *             </li>
     *             <li>
     *     		         <p>
     *                   <code>multi-attach-enabled</code> - Indicates whether the volume is enabled for Multi-Attach (<code>true</code>
     *     			| <code>false</code>)</p>
     *     	       </li>
     *             <li>
     *                <p>
     *                   <code>fast-restored</code> - Indicates whether the volume was created from a
     *           snapshot that is enabled for fast snapshot restore (<code>true</code> |
     *           <code>false</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>size</code> - The size of the volume, in GiB.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>snapshot-id</code> - The snapshot from which the volume was created.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>status</code> - The state of the volume (<code>creating</code> |
     *             <code>available</code> | <code>in-use</code> | <code>deleting</code> |
     *             <code>deleted</code> | <code>error</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-id</code> - The volume ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-type</code> - The Amazon EBS volume type (<code>gp2</code> | <code>gp3</code> | <code>io1</code> | <code>io2</code> |
     *           <code>st1</code> | <code>sc1</code>| <code>standard</code>)</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The volume IDs.</p>
     */
    VolumeIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated
     *       output. When this parameter is used, <code>DescribeVolumes</code> only returns
     *         <code>MaxResults</code> results in a single page along with a <code>NextToken</code>
     *       response element. The remaining results of the initial request can be seen by sending another
     *         <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value. This
     *       value can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500,
     *       only 500 results are returned. If this parameter is not used, then
     *         <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the
     *       volume IDs parameter in the same request.</p>
     */
    MaxResults?: number;
    /**
     * <p>The <code>NextToken</code> value returned from a previous paginated
     *         <code>DescribeVolumes</code> request where <code>MaxResults</code> was used and the results
     *       exceeded the value of that parameter. Pagination continues from the end of the previous
     *       results that returned the <code>NextToken</code> value. This value is <code>null</code> when
     *       there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVolumesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumesRequest) => any;
}
export interface DescribeVolumesResult {
    /**
     * <p>Information about the volumes.</p>
     */
    Volumes?: Volume[];
    /**
     * <p>The <code>NextToken</code> value to include in a future <code>DescribeVolumes</code>
     *       request. When the results of a <code>DescribeVolumes</code> request exceed
     *         <code>MaxResults</code>, this value can be used to retrieve the next page of results. This
     *       value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVolumesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumesResult) => any;
}
export interface DescribeVolumesModificationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the volumes.</p>
     */
    VolumeIds?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>modification-state</code> - The current modification state (modifying |
     *           optimizing | completed | failed).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>original-iops</code> - The original IOPS rate of the volume.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>original-size</code> - The original size of the volume, in GiB.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>original-volume-type</code> - The original volume type of the volume (standard |
     *           io1 | io2 | gp2 | sc1 | st1).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>start-time</code> - The modification start time.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-iops</code> - The target IOPS rate of the volume.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-size</code> - The target size of the volume, in GiB.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-volume-type</code> - The target volume type of the volume (standard |
     *           io1 | io2 | gp2 | sc1 | st1).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true | false).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-id</code> - The ID of the volume.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The <code>nextToken</code> value returned by a previous paginated request.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results (up to a limit of 500) to be returned in a paginated
     *       request.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeVolumesModificationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumesModificationsRequest) => any;
}
export declare type VolumeModificationState = "completed" | "failed" | "modifying" | "optimizing";
/**
 * <p>Describes the modification status of an EBS volume.</p>
 *          <p>If the volume has never been modified, some element values will be null.</p>
 */
export interface VolumeModification {
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId?: string;
    /**
     * <p>The current modification state. The modification state is null for unmodified
     *       volumes.</p>
     */
    ModificationState?: VolumeModificationState | string;
    /**
     * <p>A status message about the modification progress or failure.</p>
     */
    StatusMessage?: string;
    /**
     * <p>The target size of the volume, in GiB.</p>
     */
    TargetSize?: number;
    /**
     * <p>The target IOPS rate of the volume.</p>
     */
    TargetIops?: number;
    /**
     * <p>The target EBS volume type of the volume.</p>
     */
    TargetVolumeType?: VolumeType | string;
    /**
     * <p>The target throughput of the volume, in MiB/s.</p>
     */
    TargetThroughput?: number;
    /**
     * <p>The target setting for Amazon EBS Multi-Attach.</p>
     */
    TargetMultiAttachEnabled?: boolean;
    /**
     * <p>The original size of the volume, in GiB.</p>
     */
    OriginalSize?: number;
    /**
     * <p>The original IOPS rate of the volume.</p>
     */
    OriginalIops?: number;
    /**
     * <p>The original EBS volume type of the volume.</p>
     */
    OriginalVolumeType?: VolumeType | string;
    /**
     * <p>The original throughput of the volume, in MiB/s.</p>
     */
    OriginalThroughput?: number;
    /**
     * <p>The original setting for Amazon EBS Multi-Attach.</p>
     */
    OriginalMultiAttachEnabled?: boolean;
    /**
     * <p>The modification progress, from 0 to 100 percent complete.</p>
     */
    Progress?: number;
    /**
     * <p>The modification start time.</p>
     */
    StartTime?: Date;
    /**
     * <p>The modification completion or failure time.</p>
     */
    EndTime?: Date;
}
export declare namespace VolumeModification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeModification) => any;
}
export interface DescribeVolumesModificationsResult {
    /**
     * <p>Information about the volume modifications.</p>
     */
    VolumesModifications?: VolumeModification[];
    /**
     * <p>Token for pagination, null if there are no more results </p>
     */
    NextToken?: string;
}
export declare namespace DescribeVolumesModificationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumesModificationsResult) => any;
}
export interface DescribeVolumeStatusRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>action.code</code> - The action code for the event (for example,
     *             <code>enable-volume-io</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>action.description</code> - A description of the action.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>action.event-id</code> - The event ID associated with the action.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone of the instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>event.description</code> - A description of the event.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>event.event-id</code> - The event ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>event.event-type</code> - The event type (for <code>io-enabled</code>:
     *             <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     *             <code>io-performance:degraded</code> | <code>io-performance:severely-degraded</code> |
     *             <code>io-performance:stalled</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>event.not-after</code> - The latest end time for the event.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>event.not-before</code> - The earliest start time for the event.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-status.details-name</code> - The cause for
     *             <code>volume-status.status</code> (<code>io-enabled</code> |
     *           <code>io-performance</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-status.details-status</code> - The status of
     *             <code>volume-status.details-name</code> (for <code>io-enabled</code>:
     *             <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     *             <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> |
     *             <code>stalled</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>volume-status.status</code> - The status of the volume (<code>ok</code> |
     *             <code>impaired</code> | <code>warning</code> | <code>insufficient-data</code>).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in
     *       paginated output. When this parameter is used, the request only returns
     *         <code>MaxResults</code> results in a single page along with a <code>NextToken</code>
     *       response element. The remaining results of the initial request can be seen by sending another
     *       request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000;
     *       if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned.
     *       If this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You
     *       cannot specify this parameter and the volume IDs parameter in the same request.</p>
     */
    MaxResults?: number;
    /**
     * <p>The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code>
     *       request. When the results of the request exceed <code>MaxResults</code>, this value can be
     *       used to retrieve the next page of results. This value is <code>null</code> when there are no
     *       more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The IDs of the volumes.</p>
     *          <p>Default: Describes all your volumes.</p>
     */
    VolumeIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeVolumeStatusRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumeStatusRequest) => any;
}
/**
 * <p>Describes a volume status operation code.</p>
 */
export interface VolumeStatusAction {
    /**
     * <p>The code identifying the operation, for example, <code>enable-volume-io</code>.</p>
     */
    Code?: string;
    /**
     * <p>A description of the operation.</p>
     */
    Description?: string;
    /**
     * <p>The ID of the event associated with this operation.</p>
     */
    EventId?: string;
    /**
     * <p>The event type associated with this operation.</p>
     */
    EventType?: string;
}
export declare namespace VolumeStatusAction {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeStatusAction) => any;
}
/**
 * <p>Information about the instances to which the volume is attached.</p>
 */
export interface VolumeStatusAttachmentStatus {
    /**
     * <p>The maximum IOPS supported by the attached instance.</p>
     */
    IoPerformance?: string;
    /**
     * <p>The ID of the attached instance.</p>
     */
    InstanceId?: string;
}
export declare namespace VolumeStatusAttachmentStatus {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeStatusAttachmentStatus) => any;
}
/**
 * <p>Describes a volume status event.</p>
 */
export interface VolumeStatusEvent {
    /**
     * <p>A description of the event.</p>
     */
    Description?: string;
    /**
     * <p>The ID of this event.</p>
     */
    EventId?: string;
    /**
     * <p>The type of this event.</p>
     */
    EventType?: string;
    /**
     * <p>The latest end time of the event.</p>
     */
    NotAfter?: Date;
    /**
     * <p>The earliest start time of the event.</p>
     */
    NotBefore?: Date;
    /**
     * <p>The ID of the instance associated with the event.</p>
     */
    InstanceId?: string;
}
export declare namespace VolumeStatusEvent {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeStatusEvent) => any;
}
export declare type VolumeStatusName = "io-enabled" | "io-performance";
/**
 * <p>Describes a volume status.</p>
 */
export interface VolumeStatusDetails {
    /**
     * <p>The name of the volume status.</p>
     */
    Name?: VolumeStatusName | string;
    /**
     * <p>The intended status of the volume status.</p>
     */
    Status?: string;
}
export declare namespace VolumeStatusDetails {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeStatusDetails) => any;
}
export declare type VolumeStatusInfoStatus = "impaired" | "insufficient-data" | "ok";
/**
 * <p>Describes the status of a volume.</p>
 */
export interface VolumeStatusInfo {
    /**
     * <p>The details of the volume status.</p>
     */
    Details?: VolumeStatusDetails[];
    /**
     * <p>The status of the volume.</p>
     */
    Status?: VolumeStatusInfoStatus | string;
}
export declare namespace VolumeStatusInfo {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeStatusInfo) => any;
}
/**
 * <p>Describes the volume status.</p>
 */
export interface VolumeStatusItem {
    /**
     * <p>The details of the operation.</p>
     */
    Actions?: VolumeStatusAction[];
    /**
     * <p>The Availability Zone of the volume.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the Outpost.</p>
     */
    OutpostArn?: string;
    /**
     * <p>A list of events associated with the volume.</p>
     */
    Events?: VolumeStatusEvent[];
    /**
     * <p>The volume ID.</p>
     */
    VolumeId?: string;
    /**
     * <p>The volume status.</p>
     */
    VolumeStatus?: VolumeStatusInfo;
    /**
     * <p>Information about the instances to which the volume is attached.</p>
     */
    AttachmentStatuses?: VolumeStatusAttachmentStatus[];
}
export declare namespace VolumeStatusItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VolumeStatusItem) => any;
}
export interface DescribeVolumeStatusResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code>
     *       when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the status of the volumes.</p>
     */
    VolumeStatuses?: VolumeStatusItem[];
}
export declare namespace DescribeVolumeStatusResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVolumeStatusResult) => any;
}
export declare type VpcAttributeName = "enableDnsHostnames" | "enableDnsSupport";
export interface DescribeVpcAttributeRequest {
    /**
     * <p>The VPC attribute.</p>
     */
    Attribute: VpcAttributeName | string | undefined;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeVpcAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcAttributeRequest) => any;
}
export interface DescribeVpcAttributeResult {
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
    /**
     * <p>Indicates whether the instances launched in the VPC get DNS hostnames.
     * 				If this attribute is <code>true</code>, instances in the VPC get DNS hostnames;
     * 				otherwise, they do not.</p>
     */
    EnableDnsHostnames?: AttributeBooleanValue;
    /**
     * <p>Indicates whether DNS resolution is enabled for
     * 				the VPC. If this attribute is <code>true</code>, the Amazon DNS server
     * 				resolves DNS hostnames for your instances to their corresponding
     * 				IP addresses; otherwise, it does not.</p>
     */
    EnableDnsSupport?: AttributeBooleanValue;
}
export declare namespace DescribeVpcAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcAttributeResult) => any;
}
export interface DescribeVpcClassicLinkRequest {
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     * 				           <p>
     *                   <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink
     * 					   (<code>true</code> | <code>false</code>).</p>
     * 			         </li>
     *             <li>
     * 			            <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     * 			         </li>
     *             <li>
     *     			        <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     * 			         </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more VPCs for which you want to describe the ClassicLink status.</p>
     */
    VpcIds?: string[];
}
export declare namespace DescribeVpcClassicLinkRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkRequest) => any;
}
/**
 * <p>Describes whether a VPC is enabled for ClassicLink.</p>
 */
export interface VpcClassicLink {
    /**
     * <p>Indicates whether the VPC is enabled for ClassicLink.</p>
     */
    ClassicLinkEnabled?: boolean;
    /**
     * <p>Any tags assigned to the VPC.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
}
export declare namespace VpcClassicLink {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpcClassicLink) => any;
}
export interface DescribeVpcClassicLinkResult {
    /**
     * <p>The ClassicLink status of one or more VPCs.</p>
     */
    Vpcs?: VpcClassicLink[];
}
export declare namespace DescribeVpcClassicLinkResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkResult) => any;
}
export interface DescribeVpcClassicLinkDnsSupportRequest {
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>One or more VPC IDs.</p>
     */
    VpcIds?: string[];
}
export declare namespace DescribeVpcClassicLinkDnsSupportRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkDnsSupportRequest) => any;
}
/**
 * <p>Describes the ClassicLink DNS support status of a VPC.</p>
 */
export interface ClassicLinkDnsSupport {
    /**
     * <p>Indicates whether ClassicLink DNS support is enabled for the VPC.</p>
     */
    ClassicLinkDnsSupported?: boolean;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
}
export declare namespace ClassicLinkDnsSupport {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClassicLinkDnsSupport) => any;
}
export interface DescribeVpcClassicLinkDnsSupportResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the ClassicLink DNS support status of the VPCs.</p>
     */
    Vpcs?: ClassicLinkDnsSupport[];
}
export declare namespace DescribeVpcClassicLinkDnsSupportResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkDnsSupportResult) => any;
}
export interface DescribeVpcEndpointConnectionNotificationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the notification.</p>
     */
    ConnectionNotificationId?: string;
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>connection-notification-arn</code> - The ARN of the SNS topic for the
     *                     notification.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>connection-notification-id</code> - The ID of the
     *                     notification.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>connection-notification-state</code> - The state of the notification
     *                         (<code>Enabled</code> | <code>Disabled</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>connection-notification-type</code> - The type of notification
     *                         (<code>Topic</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>service-id</code> - The ID of the endpoint service.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpc-endpoint-id</code> - The ID of the VPC endpoint.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return in a single call. To retrieve the remaining
     *             results, make another request with the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to request the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionNotificationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionNotificationsRequest) => any;
}
export interface DescribeVpcEndpointConnectionNotificationsResult {
    /**
     * <p>One or more notifications.</p>
     */
    ConnectionNotificationSet?: ConnectionNotification[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is
     *             <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionNotificationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionNotificationsResult) => any;
}
export interface DescribeVpcEndpointConnectionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     *                 <p>
     *                   <code>service-id</code> - The ID of the service.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-endpoint-owner</code> - The ID of the Amazon Web Services account ID
     * 		        that owns the endpoint.</p>
     *             </li>
     *             <li>
     * 			            <p>
     *                   <code>vpc-endpoint-state</code> - The state of the endpoint
     * 			        (<code>pendingAcceptance</code> | <code>pending</code> |
     * 			        <code>available</code> | <code>deleting</code> | <code>deleted</code> |
     * 			        <code>rejected</code> | <code>failed</code>).</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>vpc-endpoint-id</code> - The ID of the endpoint.</p>
     * 			         </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining
     *             results of the initial request can be seen by sending another request with the returned
     *                 <code>NextToken</code> value. This value can be between 5 and 1,000; if
     *                 <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are
     *             returned.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionsRequest) => any;
}
/**
 * <p>Describes a VPC endpoint connection to a service.</p>
 */
export interface VpcEndpointConnection {
    /**
     * <p>The ID of the service to which the endpoint is connected.</p>
     */
    ServiceId?: string;
    /**
     * <p>The ID of the VPC endpoint.</p>
     */
    VpcEndpointId?: string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the VPC endpoint.</p>
     */
    VpcEndpointOwner?: string;
    /**
     * <p>The state of the VPC endpoint.</p>
     */
    VpcEndpointState?: State | string;
    /**
     * <p>The date and time that the VPC endpoint was created.</p>
     */
    CreationTimestamp?: Date;
    /**
     * <p>The DNS entries for the VPC endpoint.</p>
     */
    DnsEntries?: DnsEntry[];
    /**
     * <p>The Amazon Resource Names (ARNs) of the network load balancers for the service.</p>
     */
    NetworkLoadBalancerArns?: string[];
    /**
     * <p>The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.</p>
     */
    GatewayLoadBalancerArns?: string[];
}
export declare namespace VpcEndpointConnection {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpcEndpointConnection) => any;
}
export interface DescribeVpcEndpointConnectionsResult {
    /**
     * <p>Information about one or more VPC endpoint connections.</p>
     */
    VpcEndpointConnections?: VpcEndpointConnection[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionsResult) => any;
}
/**
 * <p>Contains the parameters for DescribeVpcEndpoints.</p>
 */
export interface DescribeVpcEndpointsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more endpoint IDs.</p>
     */
    VpcEndpointIds?: string[];
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                     <code>service-name</code> - The name of the service.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>vpc-id</code> - The ID of the VPC in which the endpoint resides.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                     <code>vpc-endpoint-id</code> - The ID of the endpoint.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpc-endpoint-state</code> - The state of the endpoint
     *                         (<code>pendingAcceptance</code> | <code>pending</code> |
     *                         <code>available</code> | <code>deleting</code> | <code>deleted</code> |
     *                         <code>rejected</code> | <code>failed</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpc-endpoint-type</code> - The type of VPC endpoint (<code>Interface</code> | <code>Gateway</code> | <code>GatewayLoadBalancer</code>).</p>
     *             </li>
     *             <li>
     *         		     <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *         	   </li>
     *             <li>
     *         		     <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *         	   </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>
     *         <p>Constraint: If the value is greater than 1,000, we return only 1,000 items.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of items to return. (You received this token from a prior call.)</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointsRequest) => any;
}
/**
 * <p>Contains the output of DescribeVpcEndpoints.</p>
 */
export interface DescribeVpcEndpointsResult {
    /**
     * <p>Information about the endpoints.</p>
     */
    VpcEndpoints?: VpcEndpoint[];
    /**
     * <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointsResult) => any;
}
export interface DescribeVpcEndpointServiceConfigurationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of one or more services.</p>
     */
    ServiceIds?: string[];
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     * 				           <p>
     *                   <code>service-name</code> - The name of the service.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>service-id</code> - The ID of the service.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>service-state</code> - The state of the service (<code>Pending</code> |
     *                         <code>Available</code> | <code>Deleting</code> | <code>Deleted</code> |
     *                         <code>Failed</code>). </p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     * 			         </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining
     *             results of the initial request can be seen by sending another request with the returned
     *                 <code>NextToken</code> value. This value can be between 5 and 1,000; if
     *                 <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are
     *             returned.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServiceConfigurationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointServiceConfigurationsRequest) => any;
}
export interface DescribeVpcEndpointServiceConfigurationsResult {
    /**
     * <p>Information about one or more services.</p>
     */
    ServiceConfigurations?: ServiceConfiguration[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServiceConfigurationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointServiceConfigurationsResult) => any;
}
export interface DescribeVpcEndpointServicePermissionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the service.</p>
     */
    ServiceId: string | undefined;
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     * 				           <p>
     *                   <code>principal</code> - The ARN of the principal.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>principal-type</code> - The principal type (<code>All</code> |
     * 						<code>Service</code> | <code>OrganizationUnit</code> | <code>Account</code>
     * 					| <code>User</code> | <code>Role</code>).</p>
     * 			         </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining
     *             results of the initial request can be seen by sending another request with the returned
     *                 <code>NextToken</code> value. This value can be between 5 and 1,000; if
     *                 <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are
     *             returned.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicePermissionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicePermissionsRequest) => any;
}
export interface DescribeVpcEndpointServicePermissionsResult {
    /**
     * <p>Information about one or more allowed principals.</p>
     */
    AllowedPrincipals?: AllowedPrincipal[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicePermissionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicePermissionsResult) => any;
}
/**
 * <p>Contains the parameters for DescribeVpcEndpointServices.</p>
 */
export interface DescribeVpcEndpointServicesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more service names.</p>
     */
    ServiceNames?: string[];
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>service-name</code> - The name of the service.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>service-type</code> - The type of service (<code>Interface</code> |
     *                         <code>Gateway</code>).</p>
     *             </li>
     *             <li>
     *         		     <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *         	   </li>
     *             <li>
     *         		     <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *         	   </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>
     *         <p>Constraint: If the value is greater than 1,000, we return only 1,000 items.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of items to return. (You received this token from a prior call.)</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicesRequest) => any;
}
/**
 * <p>Information about the Private DNS name for interface endpoints.</p>
 */
export interface PrivateDnsDetails {
    /**
     * <p>The private DNS name assigned to the VPC endpoint service.</p>
     */
    PrivateDnsName?: string;
}
export declare namespace PrivateDnsDetails {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PrivateDnsDetails) => any;
}
/**
 * <p>Describes a VPC endpoint service.</p>
 */
export interface ServiceDetail {
    /**
     * <p>The Amazon Resource Name (ARN) of the service.</p>
     */
    ServiceName?: string;
    /**
     * <p>The ID of the endpoint service.</p>
     */
    ServiceId?: string;
    /**
     * <p>The type of service.</p>
     */
    ServiceType?: ServiceTypeDetail[];
    /**
     * <p>The Availability Zones in which the service is available.</p>
     */
    AvailabilityZones?: string[];
    /**
     * <p>The Amazon Web Services account ID of the service owner.</p>
     */
    Owner?: string;
    /**
     * <p>The DNS names for the service.</p>
     */
    BaseEndpointDnsNames?: string[];
    /**
     * <p>The private DNS name for the service.</p>
     */
    PrivateDnsName?: string;
    /**
     * <p>The private DNS names assigned to the VPC endpoint service. </p>
     */
    PrivateDnsNames?: PrivateDnsDetails[];
    /**
     * <p>Indicates whether the service supports endpoint policies.</p>
     */
    VpcEndpointPolicySupported?: boolean;
    /**
     * <p>Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.</p>
     */
    AcceptanceRequired?: boolean;
    /**
     * <p>Indicates whether the service manages its VPC endpoints. Management of the service VPC
     *             endpoints using the VPC endpoint API is restricted.</p>
     */
    ManagesVpcEndpoints?: boolean;
    /**
     * <p>Any tags assigned to the service.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The verification state of the VPC endpoint service.</p>
     *         <p>Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.</p>
     */
    PrivateDnsNameVerificationState?: DnsNameState | string;
}
export declare namespace ServiceDetail {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ServiceDetail) => any;
}
/**
 * <p>Contains the output of DescribeVpcEndpointServices.</p>
 */
export interface DescribeVpcEndpointServicesResult {
    /**
     * <p>A list of supported services.</p>
     */
    ServiceNames?: string[];
    /**
     * <p>Information about the service.</p>
     */
    ServiceDetails?: ServiceDetail[];
    /**
     * <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicesResult) => any;
}
export interface DescribeVpcPeeringConnectionsRequest {
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                     <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the accepter
     *                     VPC.</p>
     *             </li>
     *             <li>
     *                <p>
     *                     <code>accepter-vpc-info.owner-id</code> - The ID of the Amazon Web Services account that owns the
     *                     accepter VPC.</p>
     *             </li>
     *             <li>
     *                <p>
     *                     <code>accepter-vpc-info.vpc-id</code> - The ID of the accepter VPC.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>expiration-time</code> - The expiration date and time for the VPC peering
     *           connection.</p>
     *             </li>
     *             <li>
     *                <p>
     *                     <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the
     *                     requester's VPC.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>requester-vpc-info.owner-id</code> - The ID of the Amazon Web Services account that owns the
     *                   requester VPC.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.</p>
     *             </li>
     *             <li>
     *                <p>
     *                     <code>status-code</code> - The status of the VPC peering connection
     *                         (<code>pending-acceptance</code> | <code>failed</code> |
     *                         <code>expired</code> | <code>provisioning</code> | <code>active</code> |
     *                         <code>deleting</code> | <code>deleted</code> |
     *                     <code>rejected</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>status-message</code> - A message that provides more information about the status
     *           of the VPC peering connection, if applicable.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more VPC peering connection IDs.</p>
     *          <p>Default: Describes all your VPC peering connections.</p>
     */
    VpcPeeringConnectionIds?: string[];
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeVpcPeeringConnectionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcPeeringConnectionsRequest) => any;
}
export interface DescribeVpcPeeringConnectionsResult {
    /**
     * <p>Information about the VPC peering connections.</p>
     */
    VpcPeeringConnections?: VpcPeeringConnection[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcPeeringConnectionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcPeeringConnectionsResult) => any;
}
export interface DescribeVpcsRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>cidr</code> - The primary IPv4 CIDR block of the VPC. The CIDR block you
     *                     specify must exactly match the VPC's CIDR block for information to be returned
     *                     for the VPC. Must contain the slash followed by one or two digits (for example,
     *                     <code>/28</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>cidr-block-association.cidr-block</code> - An IPv4 CIDR block associated with the
     *                     VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>cidr-block-association.association-id</code> - The association ID for
     *                     an IPv4 CIDR block associated with the VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>cidr-block-association.state</code> - The state of an IPv4 CIDR block
     *                     associated with the VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>dhcp-options-id</code> - The ID of a set of DHCP options.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR
     *                     block associated with the VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.ipv6-pool</code> - The ID of the IPv6 address pool from which the IPv6 CIDR block is allocated.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.association-id</code> - The association
     *                     ID for an IPv6 CIDR block associated with the VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR
     *                     block associated with the VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>is-default</code> - Indicates whether the VPC is the default VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the VPC (<code>pending</code> | <code>available</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpc-id</code> - The ID of the VPC.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>One or more VPC IDs.</p>
     * 		       <p>Default: Describes all your VPCs.</p>
     */
    VpcIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeVpcsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcsRequest) => any;
}
export interface DescribeVpcsResult {
    /**
     * <p>Information about one or more VPCs.</p>
     */
    Vpcs?: Vpc[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeVpcsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpcsResult) => any;
}
/**
 * <p>Contains the parameters for DescribeVpnConnections.</p>
 */
export interface DescribeVpnConnectionsRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>customer-gateway-configuration</code> - The configuration information
     *                     for the customer gateway.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>customer-gateway-id</code> - The ID of a customer gateway associated
     *                     with the VPN connection.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the VPN connection (<code>pending</code> |
     *                         <code>available</code> | <code>deleting</code> |
     *                     <code>deleted</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>option.static-routes-only</code> - Indicates whether the connection has
     *                     static routes only. Used for devices that do not support Border Gateway Protocol
     *                     (BGP).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>route.destination-cidr-block</code> - The destination CIDR block. This
     *                     corresponds to the subnet used in a customer data center.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with
     *                     a BGP device.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>type</code> - The type of VPN connection. Currently the only supported
     *                     type is <code>ipsec.1</code>.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpn-connection-id</code> - The ID of the VPN connection.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated
     *                     with the VPN connection.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>transit-gateway-id</code> - The ID of a transit gateway associated with
     *                     the VPN connection.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>One or more VPN connection IDs.</p>
     *         <p>Default: Describes your VPN connections.</p>
     */
    VpnConnectionIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeVpnConnectionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpnConnectionsRequest) => any;
}
/**
 * <p>Contains the output of DescribeVpnConnections.</p>
 */
export interface DescribeVpnConnectionsResult {
    /**
     * <p>Information about one or more VPN connections.</p>
     */
    VpnConnections?: VpnConnection[];
}
export declare namespace DescribeVpnConnectionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpnConnectionsResult) => any;
}
/**
 * <p>Contains the parameters for DescribeVpnGateways.</p>
 */
export interface DescribeVpnGatewaysRequest {
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>amazon-side-asn</code> - The Autonomous System Number (ASN) for the
     *                     Amazon side of the gateway.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>attachment.state</code> - The current state of the attachment between
     *                     the gateway and the VPC (<code>attaching</code> | <code>attached</code> |
     *                         <code>detaching</code> | <code>detached</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>attachment.vpc-id</code> - The ID of an attached VPC.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>availability-zone</code> - The Availability Zone for the virtual private
     *                     gateway (if applicable).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the virtual private gateway
     *                         (<code>pending</code> | <code>available</code> | <code>deleting</code> |
     *                         <code>deleted</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>type</code> - The type of virtual private gateway. Currently the only
     *                     supported type is <code>ipsec.1</code>.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpn-gateway-id</code> - The ID of the virtual private gateway.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>One or more virtual private gateway IDs.</p>
     *         <p>Default: Describes all your virtual private gateways.</p>
     */
    VpnGatewayIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeVpnGatewaysRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpnGatewaysRequest) => any;
}
/**
 * <p>Contains the output of DescribeVpnGateways.</p>
 */
export interface DescribeVpnGatewaysResult {
    /**
     * <p>Information about one or more virtual private gateways.</p>
     */
    VpnGateways?: VpnGateway[];
}
export declare namespace DescribeVpnGatewaysResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeVpnGatewaysResult) => any;
}
export interface DetachClassicLinkVpcRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance to unlink from the VPC.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>The ID of the VPC to which the instance is linked.</p>
     */
    VpcId: string | undefined;
}
export declare namespace DetachClassicLinkVpcRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DetachClassicLinkVpcRequest) => any;
}
export interface DetachClassicLinkVpcResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DetachClassicLinkVpcResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DetachClassicLinkVpcResult) => any;
}
export interface DetachInternetGatewayRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the internet gateway.</p>
     */
    InternetGatewayId: string | undefined;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
}
export declare namespace DetachInternetGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DetachInternetGatewayRequest) => any;
}
/**
 * <p>Contains the parameters for DetachNetworkInterface.</p>
 */
export interface DetachNetworkInterfaceRequest {
    /**
     * <p>The ID of the attachment.</p>
     */
    AttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Specifies whether to force a detachment.</p>
     *         <note>
     *             <ul>
     *                <li>
     *                     <p>Use the <code>Force</code> parameter only as a last resort to detach a network interface from a failed instance. </p>
     *                 </li>
     *                <li>
     *                     <p>If you use the <code>Force</code> parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.</p>
     *                 </li>
     *                <li>
     *                     <p>If you force the detachment of a network interface, the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">instance metadata</a>
     *                         might not get updated. This means that the attributes associated
     *                         with the detached network interface might still be visible. The
     *                         instance metadata will get updated when you stop and start the
     *                         instance.</p>
     *                 </li>
     *             </ul>
     *         </note>
     */
    Force?: boolean;
}
export declare namespace DetachNetworkInterfaceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DetachNetworkInterfaceRequest) => any;
}
export interface DetachVolumeRequest {
    /**
     * <p>The device name.</p>
     */
    Device?: string;
    /**
     * <p>Forces detachment if the previous detachment attempt did not occur cleanly (for example,
     *       logging into an instance, unmounting the volume, and detaching normally). This option can lead
     *       to data loss or a corrupted file system. Use this option only as a last resort to detach a
     *       volume from a failed instance. The instance won't have an opportunity to flush file system
     *       caches or file system metadata. If you use this option, you must perform file system check and
     *       repair procedures.</p>
     */
    Force?: boolean;
    /**
     * <p>The ID of the instance. If you are detaching a Multi-Attach enabled volume, you must specify an instance ID.</p>
     */
    InstanceId?: string;
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DetachVolumeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DetachVolumeRequest) => any;
}
/**
 * <p>Contains the parameters for DetachVpnGateway.</p>
 */
export interface DetachVpnGatewayRequest {
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
    /**
     * <p>The ID of the virtual private gateway.</p>
     */
    VpnGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DetachVpnGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DetachVpnGatewayRequest) => any;
}
export interface DisableEbsEncryptionByDefaultRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisableEbsEncryptionByDefaultRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableEbsEncryptionByDefaultRequest) => any;
}
export interface DisableEbsEncryptionByDefaultResult {
    /**
     * <p>The updated status of encryption by default.</p>
     */
    EbsEncryptionByDefault?: boolean;
}
export declare namespace DisableEbsEncryptionByDefaultResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableEbsEncryptionByDefaultResult) => any;
}
export interface DisableFastSnapshotRestoresRequest {
    /**
     * <p>One or more Availability Zones. For example, <code>us-east-2a</code>.</p>
     */
    AvailabilityZones: string[] | undefined;
    /**
     * <p>The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>.</p>
     */
    SourceSnapshotIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisableFastSnapshotRestoresRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoresRequest) => any;
}
/**
 * <p>Describes fast snapshot restores that were successfully disabled.</p>
 */
export interface DisableFastSnapshotRestoreSuccessItem {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The state of fast snapshot restores for the snapshot.</p>
     */
    State?: FastSnapshotRestoreStateCode | string;
    /**
     * <p>The reason for the state transition. The possible values are as follows:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
     *           <code>disabling</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned
     *           to <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.</p>
     *             </li>
     *          </ul>
     */
    StateTransitionReason?: string;
    /**
     * <p>The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.</p>
     */
    OwnerId?: string;
    /**
     * <p>The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.</p>
     */
    OwnerAlias?: string;
    /**
     * <p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>
     */
    EnablingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>
     */
    OptimizingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>
     */
    EnabledTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>
     */
    DisablingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>
     */
    DisabledTime?: Date;
}
export declare namespace DisableFastSnapshotRestoreSuccessItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreSuccessItem) => any;
}
/**
 * <p>Describes an error that occurred when disabling fast snapshot restores.</p>
 */
export interface DisableFastSnapshotRestoreStateError {
    /**
     * <p>The error code.</p>
     */
    Code?: string;
    /**
     * <p>The error message.</p>
     */
    Message?: string;
}
export declare namespace DisableFastSnapshotRestoreStateError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreStateError) => any;
}
/**
 * <p>Contains information about an error that occurred when disabling fast snapshot restores.</p>
 */
export interface DisableFastSnapshotRestoreStateErrorItem {
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The error.</p>
     */
    Error?: DisableFastSnapshotRestoreStateError;
}
export declare namespace DisableFastSnapshotRestoreStateErrorItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreStateErrorItem) => any;
}
/**
 * <p>Contains information about the errors that occurred when disabling fast snapshot restores.</p>
 */
export interface DisableFastSnapshotRestoreErrorItem {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The errors.</p>
     */
    FastSnapshotRestoreStateErrors?: DisableFastSnapshotRestoreStateErrorItem[];
}
export declare namespace DisableFastSnapshotRestoreErrorItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreErrorItem) => any;
}
export interface DisableFastSnapshotRestoresResult {
    /**
     * <p>Information about the snapshots for which fast snapshot restores were successfully disabled.</p>
     */
    Successful?: DisableFastSnapshotRestoreSuccessItem[];
    /**
     * <p>Information about the snapshots for which fast snapshot restores could not be disabled.</p>
     */
    Unsuccessful?: DisableFastSnapshotRestoreErrorItem[];
}
export declare namespace DisableFastSnapshotRestoresResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoresResult) => any;
}
export interface DisableImageDeprecationRequest {
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *       and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *       Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisableImageDeprecationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableImageDeprecationRequest) => any;
}
export interface DisableImageDeprecationResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DisableImageDeprecationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableImageDeprecationResult) => any;
}
export interface DisableIpamOrganizationAdminAccountRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The Organizations member account ID that you want to disable as IPAM account.</p>
     */
    DelegatedAdminAccountId: string | undefined;
}
export declare namespace DisableIpamOrganizationAdminAccountRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableIpamOrganizationAdminAccountRequest) => any;
}
export interface DisableIpamOrganizationAdminAccountResult {
    /**
     * <p>The result of disabling the IPAM account.</p>
     */
    Success?: boolean;
}
export declare namespace DisableIpamOrganizationAdminAccountResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableIpamOrganizationAdminAccountResult) => any;
}
export interface DisableSerialConsoleAccessRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisableSerialConsoleAccessRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableSerialConsoleAccessRequest) => any;
}
export interface DisableSerialConsoleAccessResult {
    /**
     * <p>If <code>true</code>, access to the EC2 serial console of all instances is enabled for
     * 			your account. If <code>false</code>, access to the EC2 serial console of all instances
     * 			is disabled for your account.</p>
     */
    SerialConsoleAccessEnabled?: boolean;
}
export declare namespace DisableSerialConsoleAccessResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableSerialConsoleAccessResult) => any;
}
export interface DisableTransitGatewayRouteTablePropagationRequest {
    /**
     * <p>The ID of the propagation route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisableTransitGatewayRouteTablePropagationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableTransitGatewayRouteTablePropagationRequest) => any;
}
export declare type TransitGatewayPropagationState = "disabled" | "disabling" | "enabled" | "enabling";
/**
 * <p>Describes route propagation.</p>
 */
export interface TransitGatewayPropagation {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.</p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId?: string;
    /**
     * <p>The state.</p>
     */
    State?: TransitGatewayPropagationState | string;
}
export declare namespace TransitGatewayPropagation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayPropagation) => any;
}
export interface DisableTransitGatewayRouteTablePropagationResult {
    /**
     * <p>Information about route propagation.</p>
     */
    Propagation?: TransitGatewayPropagation;
}
export declare namespace DisableTransitGatewayRouteTablePropagationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableTransitGatewayRouteTablePropagationResult) => any;
}
/**
 * <p>Contains the parameters for DisableVgwRoutePropagation.</p>
 */
export interface DisableVgwRoutePropagationRequest {
    /**
     * <p>The ID of the virtual private gateway.</p>
     */
    GatewayId: string | undefined;
    /**
     * <p>The ID of the route table.</p>
     */
    RouteTableId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisableVgwRoutePropagationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableVgwRoutePropagationRequest) => any;
}
export interface DisableVpcClassicLinkRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
}
export declare namespace DisableVpcClassicLinkRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableVpcClassicLinkRequest) => any;
}
export interface DisableVpcClassicLinkResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DisableVpcClassicLinkResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableVpcClassicLinkResult) => any;
}
export interface DisableVpcClassicLinkDnsSupportRequest {
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
}
export declare namespace DisableVpcClassicLinkDnsSupportRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableVpcClassicLinkDnsSupportRequest) => any;
}
export interface DisableVpcClassicLinkDnsSupportResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DisableVpcClassicLinkDnsSupportResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisableVpcClassicLinkDnsSupportResult) => any;
}
export interface DisassociateAddressRequest {
    /**
     * <p>[EC2-VPC] The association ID. Required for EC2-VPC.</p>
     */
    AssociationId?: string;
    /**
     * <p>[EC2-Classic] The Elastic IP address. Required for EC2-Classic.</p>
     */
    PublicIp?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateAddressRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateAddressRequest) => any;
}
export interface DisassociateClientVpnTargetNetworkRequest {
    /**
     * <p>The ID of the Client VPN endpoint from which to disassociate the target network.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The ID of the target network association.</p>
     */
    AssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateClientVpnTargetNetworkRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateClientVpnTargetNetworkRequest) => any;
}
export interface DisassociateClientVpnTargetNetworkResult {
    /**
     * <p>The ID of the target network association.</p>
     */
    AssociationId?: string;
    /**
     * <p>The current state of the target network association.</p>
     */
    Status?: AssociationStatus;
}
export declare namespace DisassociateClientVpnTargetNetworkResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateClientVpnTargetNetworkResult) => any;
}
export interface DisassociateEnclaveCertificateIamRoleRequest {
    /**
     * <p>The ARN of the ACM certificate from which to disassociate the IAM role.</p>
     */
    CertificateArn?: string;
    /**
     * <p>The ARN of the IAM role to disassociate.</p>
     */
    RoleArn?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateEnclaveCertificateIamRoleRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateEnclaveCertificateIamRoleRequest) => any;
}
export interface DisassociateEnclaveCertificateIamRoleResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DisassociateEnclaveCertificateIamRoleResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateEnclaveCertificateIamRoleResult) => any;
}
export interface DisassociateIamInstanceProfileRequest {
    /**
     * <p>The ID of the IAM instance profile association.</p>
     */
    AssociationId: string | undefined;
}
export declare namespace DisassociateIamInstanceProfileRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateIamInstanceProfileRequest) => any;
}
export interface DisassociateIamInstanceProfileResult {
    /**
     * <p>Information about the IAM instance profile association.</p>
     */
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export declare namespace DisassociateIamInstanceProfileResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateIamInstanceProfileResult) => any;
}
/**
 * <p>The targets to disassociate from the specified event window.</p>
 */
export interface InstanceEventWindowDisassociationRequest {
    /**
     * <p>The IDs of the instances to disassociate from the event window.</p>
     */
    InstanceIds?: string[];
    /**
     * <p>The instance tags to disassociate from the event window. Any instances associated with
     *          the tags will be disassociated from the event window.</p>
     */
    InstanceTags?: Tag[];
    /**
     * <p>The IDs of the Dedicated Hosts to disassociate from the event window.</p>
     */
    DedicatedHostIds?: string[];
}
export declare namespace InstanceEventWindowDisassociationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceEventWindowDisassociationRequest) => any;
}
export interface DisassociateInstanceEventWindowRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the event window.</p>
     */
    InstanceEventWindowId: string | undefined;
    /**
     * <p>One or more targets to disassociate from the specified event window.</p>
     */
    AssociationTarget: InstanceEventWindowDisassociationRequest | undefined;
}
export declare namespace DisassociateInstanceEventWindowRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateInstanceEventWindowRequest) => any;
}
export interface DisassociateInstanceEventWindowResult {
    /**
     * <p>Information about the event window.</p>
     */
    InstanceEventWindow?: InstanceEventWindow;
}
export declare namespace DisassociateInstanceEventWindowResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateInstanceEventWindowResult) => any;
}
export interface DisassociateRouteTableRequest {
    /**
     * <p>The association ID representing the current association between the route table and subnet or gateway.</p>
     */
    AssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateRouteTableRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateRouteTableRequest) => any;
}
export interface DisassociateSubnetCidrBlockRequest {
    /**
     * <p>The association ID for the CIDR block.</p>
     */
    AssociationId: string | undefined;
}
export declare namespace DisassociateSubnetCidrBlockRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateSubnetCidrBlockRequest) => any;
}
export interface DisassociateSubnetCidrBlockResult {
    /**
     * <p>Information about the IPv6 CIDR block association.</p>
     */
    Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
    /**
     * <p>The ID of the subnet.</p>
     */
    SubnetId?: string;
}
export declare namespace DisassociateSubnetCidrBlockResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateSubnetCidrBlockResult) => any;
}
export interface DisassociateTransitGatewayMulticastDomainRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The IDs of the subnets;</p>
     */
    SubnetIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateTransitGatewayMulticastDomainRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateTransitGatewayMulticastDomainRequest) => any;
}
export interface DisassociateTransitGatewayMulticastDomainResult {
    /**
     * <p>Information about the association.</p>
     */
    Associations?: TransitGatewayMulticastDomainAssociations;
}
export declare namespace DisassociateTransitGatewayMulticastDomainResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateTransitGatewayMulticastDomainResult) => any;
}
export interface DisassociateTransitGatewayRouteTableRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateTransitGatewayRouteTableRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateTransitGatewayRouteTableRequest) => any;
}
export interface DisassociateTransitGatewayRouteTableResult {
    /**
     * <p>Information about the association.</p>
     */
    Association?: TransitGatewayAssociation;
}
export declare namespace DisassociateTransitGatewayRouteTableResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateTransitGatewayRouteTableResult) => any;
}
export interface DisassociateTrunkInterfaceRequest {
    /**
     * <p>The ID of the association</p>
     */
    AssociationId: string | undefined;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *                 Idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DisassociateTrunkInterfaceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateTrunkInterfaceRequest) => any;
}
export interface DisassociateTrunkInterfaceResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *                 Idempotency</a>.</p>
     */
    ClientToken?: string;
}
export declare namespace DisassociateTrunkInterfaceResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateTrunkInterfaceResult) => any;
}
export interface DisassociateVpcCidrBlockRequest {
    /**
     * <p>The association ID for the CIDR block.</p>
     */
    AssociationId: string | undefined;
}
export declare namespace DisassociateVpcCidrBlockRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateVpcCidrBlockRequest) => any;
}
export interface DisassociateVpcCidrBlockResult {
    /**
     * <p>Information about the IPv6 CIDR block association.</p>
     */
    Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
    /**
     * <p>Information about the IPv4 CIDR block association.</p>
     */
    CidrBlockAssociation?: VpcCidrBlockAssociation;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
}
export declare namespace DisassociateVpcCidrBlockResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DisassociateVpcCidrBlockResult) => any;
}
export interface EnableEbsEncryptionByDefaultRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace EnableEbsEncryptionByDefaultRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableEbsEncryptionByDefaultRequest) => any;
}
export interface EnableEbsEncryptionByDefaultResult {
    /**
     * <p>The updated status of encryption by default.</p>
     */
    EbsEncryptionByDefault?: boolean;
}
export declare namespace EnableEbsEncryptionByDefaultResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableEbsEncryptionByDefaultResult) => any;
}
export interface EnableFastSnapshotRestoresRequest {
    /**
     * <p>One or more Availability Zones. For example, <code>us-east-2a</code>.</p>
     */
    AvailabilityZones: string[] | undefined;
    /**
     * <p>The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify
     *       a snapshot that was shared with you from another Amazon Web Services account.</p>
     */
    SourceSnapshotIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace EnableFastSnapshotRestoresRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoresRequest) => any;
}
/**
 * <p>Describes fast snapshot restores that were successfully enabled.</p>
 */
export interface EnableFastSnapshotRestoreSuccessItem {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The state of fast snapshot restores.</p>
     */
    State?: FastSnapshotRestoreStateCode | string;
    /**
     * <p>The reason for the state transition. The possible values are as follows:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
     *           <code>disabling</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned
     *           to <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.</p>
     *             </li>
     *          </ul>
     */
    StateTransitionReason?: string;
    /**
     * <p>The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.</p>
     */
    OwnerId?: string;
    /**
     * <p>The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.</p>
     */
    OwnerAlias?: string;
    /**
     * <p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>
     */
    EnablingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>
     */
    OptimizingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>
     */
    EnabledTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>
     */
    DisablingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>
     */
    DisabledTime?: Date;
}
export declare namespace EnableFastSnapshotRestoreSuccessItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreSuccessItem) => any;
}
/**
 * <p>Describes an error that occurred when enabling fast snapshot restores.</p>
 */
export interface EnableFastSnapshotRestoreStateError {
    /**
     * <p>The error code.</p>
     */
    Code?: string;
    /**
     * <p>The error message.</p>
     */
    Message?: string;
}
export declare namespace EnableFastSnapshotRestoreStateError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreStateError) => any;
}
/**
 * <p>Contains information about an error that occurred when enabling fast snapshot restores.</p>
 */
export interface EnableFastSnapshotRestoreStateErrorItem {
    /**
     * <p>The Availability Zone.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The error.</p>
     */
    Error?: EnableFastSnapshotRestoreStateError;
}
export declare namespace EnableFastSnapshotRestoreStateErrorItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreStateErrorItem) => any;
}
/**
 * <p>Contains information about the errors that occurred when enabling fast snapshot restores.</p>
 */
export interface EnableFastSnapshotRestoreErrorItem {
    /**
     * <p>The ID of the snapshot.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The errors.</p>
     */
    FastSnapshotRestoreStateErrors?: EnableFastSnapshotRestoreStateErrorItem[];
}
export declare namespace EnableFastSnapshotRestoreErrorItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreErrorItem) => any;
}
export interface EnableFastSnapshotRestoresResult {
    /**
     * <p>Information about the snapshots for which fast snapshot restores were successfully enabled.</p>
     */
    Successful?: EnableFastSnapshotRestoreSuccessItem[];
    /**
     * <p>Information about the snapshots for which fast snapshot restores could not be enabled.</p>
     */
    Unsuccessful?: EnableFastSnapshotRestoreErrorItem[];
}
export declare namespace EnableFastSnapshotRestoresResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoresResult) => any;
}
export interface EnableImageDeprecationRequest {
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId: string | undefined;
    /**
     * <p>The date and time to deprecate the AMI, in UTC, in the following format:
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z.
     *       If you specify a value for seconds, Amazon EC2 rounds the seconds to the
     *       nearest minute.</p>
     *          <p>You can’t specify a date in the past. The upper limit for <code>DeprecateAt</code> is 10
     *       years from now.</p>
     */
    DeprecateAt: Date | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *       and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *       Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace EnableImageDeprecationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableImageDeprecationRequest) => any;
}
export interface EnableImageDeprecationResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace EnableImageDeprecationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableImageDeprecationResult) => any;
}
export interface EnableIpamOrganizationAdminAccountRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The Organizations member account ID that you want to enable as the IPAM account.</p>
     */
    DelegatedAdminAccountId: string | undefined;
}
export declare namespace EnableIpamOrganizationAdminAccountRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableIpamOrganizationAdminAccountRequest) => any;
}
export interface EnableIpamOrganizationAdminAccountResult {
    /**
     * <p>The result of enabling the IPAM account.</p>
     */
    Success?: boolean;
}
export declare namespace EnableIpamOrganizationAdminAccountResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableIpamOrganizationAdminAccountResult) => any;
}
export interface EnableSerialConsoleAccessRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace EnableSerialConsoleAccessRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableSerialConsoleAccessRequest) => any;
}
export interface EnableSerialConsoleAccessResult {
    /**
     * <p>If <code>true</code>, access to the EC2 serial console of all instances is enabled for
     * 			your account. If <code>false</code>, access to the EC2 serial console of all instances
     * 			is disabled for your account.</p>
     */
    SerialConsoleAccessEnabled?: boolean;
}
export declare namespace EnableSerialConsoleAccessResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableSerialConsoleAccessResult) => any;
}
export interface EnableTransitGatewayRouteTablePropagationRequest {
    /**
     * <p>The ID of the propagation route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace EnableTransitGatewayRouteTablePropagationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableTransitGatewayRouteTablePropagationRequest) => any;
}
export interface EnableTransitGatewayRouteTablePropagationResult {
    /**
     * <p>Information about route propagation.</p>
     */
    Propagation?: TransitGatewayPropagation;
}
export declare namespace EnableTransitGatewayRouteTablePropagationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableTransitGatewayRouteTablePropagationResult) => any;
}
/**
 * <p>Contains the parameters for EnableVgwRoutePropagation.</p>
 */
export interface EnableVgwRoutePropagationRequest {
    /**
     * <p>The ID of the virtual private gateway that is attached to a VPC. The virtual private
     *             gateway must be attached to the same VPC that the routing tables are associated with.
     *         </p>
     */
    GatewayId: string | undefined;
    /**
     * <p>The ID of the route table. The routing table must be associated with the same VPC that
     *             the virtual private gateway is attached to. </p>
     */
    RouteTableId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace EnableVgwRoutePropagationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableVgwRoutePropagationRequest) => any;
}
export interface EnableVolumeIORequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId: string | undefined;
}
export declare namespace EnableVolumeIORequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableVolumeIORequest) => any;
}
export interface EnableVpcClassicLinkRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
}
export declare namespace EnableVpcClassicLinkRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableVpcClassicLinkRequest) => any;
}
export interface EnableVpcClassicLinkResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace EnableVpcClassicLinkResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableVpcClassicLinkResult) => any;
}
export interface EnableVpcClassicLinkDnsSupportRequest {
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
}
export declare namespace EnableVpcClassicLinkDnsSupportRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableVpcClassicLinkDnsSupportRequest) => any;
}
export interface EnableVpcClassicLinkDnsSupportResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace EnableVpcClassicLinkDnsSupportResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: EnableVpcClassicLinkDnsSupportResult) => any;
}
export interface ExportClientVpnClientCertificateRevocationListRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ExportClientVpnClientCertificateRevocationListRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportClientVpnClientCertificateRevocationListRequest) => any;
}
export declare type ClientCertificateRevocationListStatusCode = "active" | "pending";
/**
 * <p>Describes the state of a client certificate revocation list.</p>
 */
export interface ClientCertificateRevocationListStatus {
    /**
     * <p>The state of the client certificate revocation list.</p>
     */
    Code?: ClientCertificateRevocationListStatusCode | string;
    /**
     * <p>A message about the status of the client certificate revocation list, if applicable.</p>
     */
    Message?: string;
}
export declare namespace ClientCertificateRevocationListStatus {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientCertificateRevocationListStatus) => any;
}
export interface ExportClientVpnClientCertificateRevocationListResult {
    /**
     * <p>Information about the client certificate revocation list.</p>
     */
    CertificateRevocationList?: string;
    /**
     * <p>The current state of the client certificate revocation list.</p>
     */
    Status?: ClientCertificateRevocationListStatus;
}
export declare namespace ExportClientVpnClientCertificateRevocationListResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportClientVpnClientCertificateRevocationListResult) => any;
}
export interface ExportClientVpnClientConfigurationRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ExportClientVpnClientConfigurationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportClientVpnClientConfigurationRequest) => any;
}
export interface ExportClientVpnClientConfigurationResult {
    /**
     * <p>The contents of the Client VPN endpoint configuration file.</p>
     */
    ClientConfiguration?: string;
}
export declare namespace ExportClientVpnClientConfigurationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportClientVpnClientConfigurationResult) => any;
}
/**
 * <p>Describes the destination for an export image task.</p>
 */
export interface ExportTaskS3LocationRequest {
    /**
     * <p>The destination Amazon S3 bucket.</p>
     */
    S3Bucket: string | undefined;
    /**
     * <p>The prefix (logical hierarchy) in the bucket.</p>
     */
    S3Prefix?: string;
}
export declare namespace ExportTaskS3LocationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportTaskS3LocationRequest) => any;
}
export interface ExportImageRequest {
    /**
     * <p>Token to enable idempotency for export image requests.</p>
     */
    ClientToken?: string;
    /**
     * <p>A description of the image being exported. The maximum length is 255 characters.</p>
     */
    Description?: string;
    /**
     * <p>The disk image format.</p>
     */
    DiskImageFormat: DiskImageFormat | string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the image.</p>
     */
    ImageId: string | undefined;
    /**
     * <p>Information about the destination Amazon S3 bucket. The bucket must exist and grant WRITE
     *    and READ_ACP permissions to the Amazon Web Services account vm-import-export@amazon.com.</p>
     */
    S3ExportLocation: ExportTaskS3LocationRequest | undefined;
    /**
     * <p>The name of the role that grants VM Import/Export permission to export images to your Amazon
     *    S3 bucket. If this parameter is not specified, the default role is named 'vmimport'.</p>
     */
    RoleName?: string;
    /**
     * <p>The tags to apply to the export image task during creation.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace ExportImageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportImageRequest) => any;
}
export interface ExportImageResult {
    /**
     * <p>A description of the image being exported.</p>
     */
    Description?: string;
    /**
     * <p>The disk image format for the exported image.</p>
     */
    DiskImageFormat?: DiskImageFormat | string;
    /**
     * <p>The ID of the export image task.</p>
     */
    ExportImageTaskId?: string;
    /**
     * <p>The ID of the image.</p>
     */
    ImageId?: string;
    /**
     * <p>The name of the role that grants VM Import/Export permission to export images to your Amazon
     *    S3 bucket.</p>
     */
    RoleName?: string;
    /**
     * <p>The percent complete of the export image task.</p>
     */
    Progress?: string;
    /**
     * <p>Information about the destination Amazon S3 bucket.</p>
     */
    S3ExportLocation?: ExportTaskS3Location;
    /**
     * <p>The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
     *     <code>deleting</code>, and <code>deleted</code>.</p>
     */
    Status?: string;
    /**
     * <p>The status message for the export image task.</p>
     */
    StatusMessage?: string;
    /**
     * <p>Any tags assigned to the export image task.</p>
     */
    Tags?: Tag[];
}
export declare namespace ExportImageResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportImageResult) => any;
}
export interface ExportTransitGatewayRoutesRequest {
    /**
     * <p>The ID of the route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>attachment.transit-gateway-attachment-id</code> - The id of the transit gateway attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.resource-id</code> - The resource id of the transit gateway attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.exact-match</code> - The exact match of the specified filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.longest-prefix-match</code> - The longest prefix that matches the route.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.subnet-of-match</code> - The routes with a subnet that match the specified CIDR filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.supernet-of-match</code> - The routes with a CIDR that encompass the CIDR filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the route (<code>active</code> | <code>blackhole</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>type</code> - The type of route (<code>propagated</code> |
     *                <code>static</code>).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The name of the S3 bucket.</p>
     */
    S3Bucket: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace ExportTransitGatewayRoutesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportTransitGatewayRoutesRequest) => any;
}
export interface ExportTransitGatewayRoutesResult {
    /**
     * <p>The URL of the exported file in Amazon S3. For example,
     *          s3://<i>bucket_name</i>/VPCTransitGateway/TransitGatewayRouteTables/<i>file_name</i>.</p>
     */
    S3Location?: string;
}
export declare namespace ExportTransitGatewayRoutesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ExportTransitGatewayRoutesResult) => any;
}
export interface GetAssociatedEnclaveCertificateIamRolesRequest {
    /**
     * <p>The ARN of the ACM certificate for which to view the associated IAM roles, encryption keys, and Amazon
     * 			S3 object information.</p>
     */
    CertificateArn?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetAssociatedEnclaveCertificateIamRolesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetAssociatedEnclaveCertificateIamRolesRequest) => any;
}
/**
 * <p>Information about the associated IAM roles.</p>
 */
export interface AssociatedRole {
    /**
     * <p>The ARN of the associated IAM role.</p>
     */
    AssociatedRoleArn?: string;
    /**
     * <p>The name of the Amazon S3 bucket in which the Amazon S3 object is stored.</p>
     */
    CertificateS3BucketName?: string;
    /**
     * <p>The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle
     * 			is stored. The object key is formated as follows:  <code>role_arn</code>/<code>certificate_arn</code>.
     * 		</p>
     */
    CertificateS3ObjectKey?: string;
    /**
     * <p>The ID of the KMS customer master key (CMK) used to encrypt the private key.</p>
     */
    EncryptionKmsKeyId?: string;
}
export declare namespace AssociatedRole {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: AssociatedRole) => any;
}
export interface GetAssociatedEnclaveCertificateIamRolesResult {
    /**
     * <p>Information about the associated IAM roles.</p>
     */
    AssociatedRoles?: AssociatedRole[];
}
export declare namespace GetAssociatedEnclaveCertificateIamRolesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetAssociatedEnclaveCertificateIamRolesResult) => any;
}
export interface GetAssociatedIpv6PoolCidrsRequest {
    /**
     * <p>The ID of the IPv6 address pool.</p>
     */
    PoolId: string | undefined;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetAssociatedIpv6PoolCidrsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetAssociatedIpv6PoolCidrsRequest) => any;
}
/**
 * <p>Describes an IPv6 CIDR block association.</p>
 */
export interface Ipv6CidrAssociation {
    /**
     * <p>The IPv6 CIDR block.</p>
     */
    Ipv6Cidr?: string;
    /**
     * <p>The resource that's associated with the IPv6 CIDR block.</p>
     */
    AssociatedResource?: string;
}
export declare namespace Ipv6CidrAssociation {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Ipv6CidrAssociation) => any;
}
export interface GetAssociatedIpv6PoolCidrsResult {
    /**
     * <p>Information about the IPv6 CIDR block associations.</p>
     */
    Ipv6CidrAssociations?: Ipv6CidrAssociation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetAssociatedIpv6PoolCidrsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetAssociatedIpv6PoolCidrsResult) => any;
}
export interface GetCapacityReservationUsageRequest {
    /**
     * <p>The ID of the Capacity Reservation.</p>
     */
    CapacityReservationId: string | undefined;
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     * 		       <p>Valid range: Minimum value of 1. Maximum value of 1000.</p>
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetCapacityReservationUsageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetCapacityReservationUsageRequest) => any;
}
/**
 * <p>Information about the Capacity Reservation usage.</p>
 */
export interface InstanceUsage {
    /**
     * <p>The ID of the Amazon Web Services account that is making use of the Capacity Reservation.</p>
     */
    AccountId?: string;
    /**
     * <p>The number of instances the Amazon Web Services account currently has in the Capacity Reservation.</p>
     */
    UsedInstanceCount?: number;
}
export declare namespace InstanceUsage {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceUsage) => any;
}
export interface GetCapacityReservationUsageResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the Capacity Reservation.</p>
     */
    CapacityReservationId?: string;
    /**
     * <p>The type of instance for which the Capacity Reservation reserves capacity.</p>
     */
    InstanceType?: string;
    /**
     * <p>The number of instances for which the Capacity Reservation reserves capacity.</p>
     */
    TotalInstanceCount?: number;
    /**
     * <p>The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.</p>
     */
    AvailableInstanceCount?: number;
    /**
     * <p>The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p>
     * 			      <ul>
     *             <li>
     *                <p>
     *                   <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
     * 					in your request. The reserved capacity is no longer available for your use.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no
     * 					longer available for your use.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>pending</code> - The Capacity Reservation request was successful but the capacity
     * 					provisioning is still pending.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>failed</code> - The Capacity Reservation request has failed. A request might fail
     * 					due to invalid request parameters, capacity constraints, or instance limit constraints.
     * 					Failed requests are retained for 60 minutes.</p>
     *             </li>
     *          </ul>
     */
    State?: CapacityReservationState | string;
    /**
     * <p>Information about the Capacity Reservation usage.</p>
     */
    InstanceUsages?: InstanceUsage[];
}
export declare namespace GetCapacityReservationUsageResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetCapacityReservationUsageResult) => any;
}
export interface GetCoipPoolUsageRequest {
    /**
     * <p>The ID of the address pool.</p>
     */
    PoolId: string | undefined;
    /**
     * <p>The filters. The following are the possible values:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-address-usage.allocation-id</code>
     *                </p>
     *             </li>
     *          </ul>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-address-usage.aws-account-id</code>
     *                </p>
     *             </li>
     *          </ul>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-address-usage.aws-service</code>
     *                </p>
     *             </li>
     *          </ul>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-address-usage.co-ip</code>
     *                </p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetCoipPoolUsageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetCoipPoolUsageRequest) => any;
}
/**
 * <p>Describes address usage for a customer-owned address pool.</p>
 */
export interface CoipAddressUsage {
    /**
     * <p>The allocation ID of the address.</p>
     */
    AllocationId?: string;
    /**
     * <p>The Amazon Web Services account ID.</p>
     */
    AwsAccountId?: string;
    /**
     * <p>The Amazon Web Services service.</p>
     */
    AwsService?: string;
    /**
     * <p>The customer-owned IP address.</p>
     */
    CoIp?: string;
}
export declare namespace CoipAddressUsage {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CoipAddressUsage) => any;
}
export interface GetCoipPoolUsageResult {
    /**
     * <p>The ID of the customer-owned address pool.</p>
     */
    CoipPoolId?: string;
    /**
     * <p>Information about the address usage.</p>
     */
    CoipAddressUsages?: CoipAddressUsage[];
    /**
     * <p>The ID of the local gateway route table.</p>
     */
    LocalGatewayRouteTableId?: string;
}
export declare namespace GetCoipPoolUsageResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetCoipPoolUsageResult) => any;
}
export interface GetConsoleOutputRequest {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>When enabled, retrieves the latest console output for the instance.</p>
     *         <p>Default: disabled (<code>false</code>)</p>
     */
    Latest?: boolean;
}
export declare namespace GetConsoleOutputRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetConsoleOutputRequest) => any;
}
export interface GetConsoleOutputResult {
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The console output, base64-encoded. If you are using a command line tool, the tool
     *             decodes the output for you.</p>
     */
    Output?: string;
    /**
     * <p>The time at which the output was last updated.</p>
     */
    Timestamp?: Date;
}
export declare namespace GetConsoleOutputResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetConsoleOutputResult) => any;
}
export interface GetConsoleScreenshotRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId: string | undefined;
    /**
     * <p>When set to <code>true</code>, acts as keystroke input and wakes up an instance that's
     *             in standby or "sleep" mode.</p>
     */
    WakeUp?: boolean;
}
export declare namespace GetConsoleScreenshotRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetConsoleScreenshotRequest) => any;
}
export interface GetConsoleScreenshotResult {
    /**
     * <p>The data that comprises the image.</p>
     */
    ImageData?: string;
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
}
export declare namespace GetConsoleScreenshotResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetConsoleScreenshotResult) => any;
}
export declare type UnlimitedSupportedInstanceFamily = "t2" | "t3" | "t3a" | "t4g";
export interface GetDefaultCreditSpecificationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The instance family.</p>
     */
    InstanceFamily: UnlimitedSupportedInstanceFamily | string | undefined;
}
export declare namespace GetDefaultCreditSpecificationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetDefaultCreditSpecificationRequest) => any;
}
/**
 * <p>Describes the default credit option for CPU usage of a burstable performance instance family.</p>
 */
export interface InstanceFamilyCreditSpecification {
    /**
     * <p>The instance family.</p>
     */
    InstanceFamily?: UnlimitedSupportedInstanceFamily | string;
    /**
     * <p>The default credit option for CPU usage of the instance family. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
     */
    CpuCredits?: string;
}
export declare namespace InstanceFamilyCreditSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceFamilyCreditSpecification) => any;
}
export interface GetDefaultCreditSpecificationResult {
    /**
     * <p>The default credit option for CPU usage of the instance family.</p>
     */
    InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export declare namespace GetDefaultCreditSpecificationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetDefaultCreditSpecificationResult) => any;
}
export interface GetEbsDefaultKmsKeyIdRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetEbsDefaultKmsKeyIdRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetEbsDefaultKmsKeyIdRequest) => any;
}
export interface GetEbsDefaultKmsKeyIdResult {
    /**
     * <p>The Amazon Resource Name (ARN) of the default KMS key for encryption by default.</p>
     */
    KmsKeyId?: string;
}
export declare namespace GetEbsDefaultKmsKeyIdResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetEbsDefaultKmsKeyIdResult) => any;
}
export interface GetEbsEncryptionByDefaultRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetEbsEncryptionByDefaultRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetEbsEncryptionByDefaultRequest) => any;
}
export interface GetEbsEncryptionByDefaultResult {
    /**
     * <p>Indicates whether encryption by default is enabled.</p>
     */
    EbsEncryptionByDefault?: boolean;
}
export declare namespace GetEbsEncryptionByDefaultResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetEbsEncryptionByDefaultResult) => any;
}
export declare enum PartitionLoadFrequency {
    DAILY = "daily",
    MONTHLY = "monthly",
    NONE = "none",
    WEEKLY = "weekly"
}
/**
 * <p>Describes integration options for Amazon Athena.</p>
 */
export interface AthenaIntegration {
    /**
     * <p>The location in Amazon S3 to store the generated CloudFormation template.</p>
     */
    IntegrationResultS3DestinationArn: string | undefined;
    /**
     * <p>The schedule for adding new partitions to the table.</p>
     */
    PartitionLoadFrequency: PartitionLoadFrequency | string | undefined;
    /**
     * <p>The start date for the partition.</p>
     */
    PartitionStartDate?: Date;
    /**
     * <p>The end date for the partition.</p>
     */
    PartitionEndDate?: Date;
}
export declare namespace AthenaIntegration {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: AthenaIntegration) => any;
}
/**
 * <p>Describes service integrations with VPC Flow logs.</p>
 */
export interface IntegrateServices {
    /**
     * <p>Information about the integration with Amazon Athena.</p>
     */
    AthenaIntegrations?: AthenaIntegration[];
}
export declare namespace IntegrateServices {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IntegrateServices) => any;
}
export interface GetFlowLogsIntegrationTemplateRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the flow log.</p>
     */
    FlowLogId: string | undefined;
    /**
     * <p>To store the CloudFormation template in Amazon S3, specify the location in Amazon S3.</p>
     */
    ConfigDeliveryS3DestinationArn: string | undefined;
    /**
     * <p>Information about the service integration.</p>
     */
    IntegrateServices: IntegrateServices | undefined;
}
export declare namespace GetFlowLogsIntegrationTemplateRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetFlowLogsIntegrationTemplateRequest) => any;
}
export interface GetFlowLogsIntegrationTemplateResult {
    /**
     * <p>The generated CloudFormation template.</p>
     */
    Result?: string;
}
export declare namespace GetFlowLogsIntegrationTemplateResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetFlowLogsIntegrationTemplateResult) => any;
}
export interface GetGroupsForCapacityReservationRequest {
    /**
     * <p>The ID of the Capacity Reservation.</p>
     */
    CapacityReservationId: string | undefined;
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace GetGroupsForCapacityReservationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetGroupsForCapacityReservationRequest) => any;
}
/**
 * <p>Describes a resource group to which a Capacity Reservation has been added.</p>
 */
export interface CapacityReservationGroup {
    /**
     * <p>The ARN of the resource group.</p>
     */
    GroupArn?: string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the resource group.</p>
     */
    OwnerId?: string;
}
export declare namespace CapacityReservationGroup {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CapacityReservationGroup) => any;
}
export interface GetGroupsForCapacityReservationResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the resource groups to which the Capacity Reservation has been added.</p>
     */
    CapacityReservationGroups?: CapacityReservationGroup[];
}
export declare namespace GetGroupsForCapacityReservationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetGroupsForCapacityReservationResult) => any;
}
export interface GetHostReservationPurchasePreviewRequest {
    /**
     * <p>The IDs of the Dedicated Hosts with which the reservation is associated.</p>
     */
    HostIdSet: string[] | undefined;
    /**
     * <p>The offering ID of the reservation.</p>
     */
    OfferingId: string | undefined;
}
export declare namespace GetHostReservationPurchasePreviewRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetHostReservationPurchasePreviewRequest) => any;
}
/**
 * <p>Describes the result of the purchase.</p>
 */
export interface Purchase {
    /**
     * <p>The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code>
     *             amounts are specified. At this time, the only supported currency is
     *             <code>USD</code>.</p>
     */
    CurrencyCode?: CurrencyCodeValues | string;
    /**
     * <p>The duration of the reservation's term in seconds.</p>
     */
    Duration?: number;
    /**
     * <p>The IDs of the Dedicated Hosts associated with the reservation.</p>
     */
    HostIdSet?: string[];
    /**
     * <p>The ID of the reservation.</p>
     */
    HostReservationId?: string;
    /**
     * <p>The hourly price of the reservation per hour.</p>
     */
    HourlyPrice?: string;
    /**
     * <p>The instance family on the Dedicated Host that the reservation can be associated
     *             with.</p>
     */
    InstanceFamily?: string;
    /**
     * <p>The payment option for the reservation.</p>
     */
    PaymentOption?: PaymentOption | string;
    /**
     * <p>The upfront price of the reservation.</p>
     */
    UpfrontPrice?: string;
}
export declare namespace Purchase {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Purchase) => any;
}
export interface GetHostReservationPurchasePreviewResult {
    /**
     * <p>The currency in which the <code>totalUpfrontPrice</code> and
     *                 <code>totalHourlyPrice</code> amounts are specified. At this time, the only
     *             supported currency is <code>USD</code>.</p>
     */
    CurrencyCode?: CurrencyCodeValues | string;
    /**
     * <p>The purchase information of the Dedicated Host reservation and the Dedicated Hosts
     *             associated with it.</p>
     */
    Purchase?: Purchase[];
    /**
     * <p>The potential total hourly price of the reservation per hour.</p>
     */
    TotalHourlyPrice?: string;
    /**
     * <p>The potential total upfront price. This is billed immediately.</p>
     */
    TotalUpfrontPrice?: string;
}
export declare namespace GetHostReservationPurchasePreviewResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetHostReservationPurchasePreviewResult) => any;
}
export interface GetInstanceTypesFromInstanceRequirementsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The processor architecture type.</p>
     */
    ArchitectureTypes: (ArchitectureType | string)[] | undefined;
    /**
     * <p>The virtualization type.</p>
     */
    VirtualizationTypes: (VirtualizationType | string)[] | undefined;
    /**
     * <p>The attributes required for the instance types.</p>
     */
    InstanceRequirements: InstanceRequirementsRequest | undefined;
    /**
     * <p>The maximum number of results to return in a single call. Specify a value between 1 and
     *          1000. The default value is 1000. To retrieve the remaining results, make another call with
     *          the returned <code>NextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetInstanceTypesFromInstanceRequirementsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetInstanceTypesFromInstanceRequirementsRequest) => any;
}
/**
 * <p>The list of instance types with the specified instance attributes.</p>
 */
export interface InstanceTypeInfoFromInstanceRequirements {
    /**
     * <p>The matching instance type.</p>
     */
    InstanceType?: string;
}
export declare namespace InstanceTypeInfoFromInstanceRequirements {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceTypeInfoFromInstanceRequirements) => any;
}
export interface GetInstanceTypesFromInstanceRequirementsResult {
    /**
     * <p>The instance types with the specified instance attributes.</p>
     */
    InstanceTypes?: InstanceTypeInfoFromInstanceRequirements[];
    /**
     * <p>The token for the next set of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetInstanceTypesFromInstanceRequirementsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetInstanceTypesFromInstanceRequirementsResult) => any;
}
export interface GetIpamAddressHistoryRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The CIDR you want the history of. The CIDR can be an IPv4 or IPv6 IP address range.
     *          If you enter a /16 IPv4 CIDR, you will get records that match it exactly. You will not get records for any subnets within the /16 CIDR.</p>
     */
    Cidr: string | undefined;
    /**
     * <p>The ID of the IPAM scope that the CIDR is in.</p>
     */
    IpamScopeId: string | undefined;
    /**
     * <p>The ID of the VPC you want your history records filtered by.</p>
     */
    VpcId?: string;
    /**
     * <p>The start of the time period for which you are looking for history. If you omit this option, it will default to the value of EndTime.</p>
     */
    StartTime?: Date;
    /**
     * <p>The end of the time period for which you are looking for history. If you omit this option, it will default to the current time.</p>
     */
    EndTime?: Date;
    /**
     * <p>The maximum number of historical results you would like returned per page. Defaults to 100.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetIpamAddressHistoryRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamAddressHistoryRequest) => any;
}
export declare enum IpamComplianceStatus {
    compliant = "compliant",
    ignored = "ignored",
    noncompliant = "noncompliant",
    unmanaged = "unmanaged"
}
export declare enum IpamOverlapStatus {
    ignored = "ignored",
    nonoverlapping = "nonoverlapping",
    overlapping = "overlapping"
}
export declare enum IpamAddressHistoryResourceType {
    eip = "eip",
    instance = "instance",
    network_interface = "network-interface",
    subnet = "subnet",
    vpc = "vpc"
}
/**
 * <p>The historical record of a CIDR within an IPAM scope. For more information, see <a href="/vpc/latest/ipam/view-history-cidr-ipam.html">View the history of IP addresses</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 */
export interface IpamAddressHistoryRecord {
    /**
     * <p>The ID of the resource owner.</p>
     */
    ResourceOwnerId?: string;
    /**
     * <p>The Amazon Web Services Region of the resource.</p>
     */
    ResourceRegion?: string;
    /**
     * <p>The type of the resource.</p>
     */
    ResourceType?: IpamAddressHistoryResourceType | string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The CIDR of the resource.</p>
     */
    ResourceCidr?: string;
    /**
     * <p>The name of the resource.</p>
     */
    ResourceName?: string;
    /**
     * <p>The compliance status of a resource. For more information on compliance statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    ResourceComplianceStatus?: IpamComplianceStatus | string;
    /**
     * <p>The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with another CIDR in the scope. For more information on overlap statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    ResourceOverlapStatus?: IpamOverlapStatus | string;
    /**
     * <p>The VPC ID of the resource.</p>
     */
    VpcId?: string;
    /**
     * <p>Sampled start time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic snapshots, so the start time may have occurred before this specific time.</p>
     */
    SampledStartTime?: Date;
    /**
     * <p>Sampled end time of the resource-to-CIDR association within the IPAM scope. Changes are picked up in periodic snapshots, so the end time may have occurred before this specific time.</p>
     */
    SampledEndTime?: Date;
}
export declare namespace IpamAddressHistoryRecord {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IpamAddressHistoryRecord) => any;
}
export interface GetIpamAddressHistoryResult {
    /**
     * <p>A historical record for a CIDR within an IPAM scope. If the CIDR is associated with an EC2 instance, you will see an object in the response for the instance and one for the network interface.</p>
     */
    HistoryRecords?: IpamAddressHistoryRecord[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetIpamAddressHistoryResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamAddressHistoryResult) => any;
}
export interface GetIpamPoolAllocationsRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool you want to see the allocations for.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The ID of the allocation.</p>
     */
    IpamPoolAllocationId?: string;
    /**
     * <p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results you would like returned per page.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetIpamPoolAllocationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamPoolAllocationsRequest) => any;
}
export interface GetIpamPoolAllocationsResult {
    /**
     * <p>The IPAM pool allocations you want information on.</p>
     */
    IpamPoolAllocations?: IpamPoolAllocation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetIpamPoolAllocationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamPoolAllocationsResult) => any;
}
export interface GetIpamPoolCidrsRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool you want the CIDR for.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return in the request.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace GetIpamPoolCidrsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamPoolCidrsRequest) => any;
}
export interface GetIpamPoolCidrsResult {
    /**
     * <p>Information about the CIDRs provisioned to an IPAM pool.</p>
     */
    IpamPoolCidrs?: IpamPoolCidr[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace GetIpamPoolCidrsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamPoolCidrsResult) => any;
}
export declare enum IpamResourceType {
    eip = "eip",
    ipv6_pool = "ipv6-pool",
    public_ipv4_pool = "public-ipv4-pool",
    subnet = "subnet",
    vpc = "vpc"
}
export interface GetIpamResourceCidrsRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return in the request.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The ID of the scope that the resource is in.</p>
     */
    IpamScopeId: string | undefined;
    /**
     * <p>The ID of the IPAM pool that the resource is in.</p>
     */
    IpamPoolId?: string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The resource type.</p>
     */
    ResourceType?: IpamResourceType | string;
    /**
     * <p>A tag on an IPAM resource.</p>
     */
    ResourceTag?: RequestIpamResourceTag;
    /**
     * <p>The ID of the Amazon Web Services account that owns the resource.</p>
     */
    ResourceOwner?: string;
}
export declare namespace GetIpamResourceCidrsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamResourceCidrsRequest) => any;
}
export declare enum IpamManagementState {
    ignored = "ignored",
    managed = "managed",
    unmanaged = "unmanaged"
}
/**
 * <p>The CIDR for an IPAM resource.</p>
 */
export interface IpamResourceCidr {
    /**
     * <p>The IPAM ID for an IPAM resource.</p>
     */
    IpamId?: string;
    /**
     * <p>The scope ID for an IPAM resource.</p>
     */
    IpamScopeId?: string;
    /**
     * <p>The pool ID for an IPAM resource.</p>
     */
    IpamPoolId?: string;
    /**
     * <p>The Amazon Web Services Region for an IPAM resource.</p>
     */
    ResourceRegion?: string;
    /**
     * <p>The Amazon Web Services account number of the owner of an IPAM resource.</p>
     */
    ResourceOwnerId?: string;
    /**
     * <p>The ID of an IPAM resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The name of an IPAM resource.</p>
     */
    ResourceName?: string;
    /**
     * <p>The CIDR for an IPAM resource.</p>
     */
    ResourceCidr?: string;
    /**
     * <p>The type of IPAM resource.</p>
     */
    ResourceType?: IpamResourceType | string;
    /**
     * <p>The tags for an IPAM resource.</p>
     */
    ResourceTags?: IpamResourceTag[];
    /**
     * <p>The IP address space in the IPAM pool that is allocated to this resource. To convert the decimal to a percentage, multiply the decimal by 100.</p>
     */
    IpUsage?: number;
    /**
     * <p>The compliance status of the IPAM resource. For more information on compliance statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    ComplianceStatus?: IpamComplianceStatus | string;
    /**
     * <p>The management state of the resource. For more information about management states, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    ManagementState?: IpamManagementState | string;
    /**
     * <p>The overlap status of an IPAM resource. The overlap status tells you if the CIDR for a resource overlaps with another CIDR in the scope. For more information on overlap statuses, see <a href="/vpc/latest/ipam/monitor-cidr-compliance-ipam.html">Monitor CIDR usage by resource</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    OverlapStatus?: IpamOverlapStatus | string;
    /**
     * <p>The ID of a VPC.</p>
     */
    VpcId?: string;
}
export declare namespace IpamResourceCidr {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IpamResourceCidr) => any;
}
export interface GetIpamResourceCidrsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>The resource CIDRs.</p>
     */
    IpamResourceCidrs?: IpamResourceCidr[];
}
export declare namespace GetIpamResourceCidrsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetIpamResourceCidrsResult) => any;
}
export interface GetLaunchTemplateDataRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId: string | undefined;
}
export declare namespace GetLaunchTemplateDataRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: GetLaunchTemplateDataRequest) => any;
}
