import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeNetworkInsightsAccessScopeAnalysesRequest, DescribeNetworkInsightsAccessScopeAnalysesResult } from "../models/models_3";
export interface DescribeNetworkInsightsAccessScopeAnalysesCommandInput extends DescribeNetworkInsightsAccessScopeAnalysesRequest {
}
export interface DescribeNetworkInsightsAccessScopeAnalysesCommandOutput extends DescribeNetworkInsightsAccessScopeAnalysesResult, __MetadataBearer {
}
/**
 * <p>Describes the specified Network Access Scope analyses.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeNetworkInsightsAccessScopeAnalysesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeNetworkInsightsAccessScopeAnalysesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeNetworkInsightsAccessScopeAnalysesCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeNetworkInsightsAccessScopeAnalysesCommandInput} for command's `input` shape.
 * @see {@link DescribeNetworkInsightsAccessScopeAnalysesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeNetworkInsightsAccessScopeAnalysesCommand extends $Command<DescribeNetworkInsightsAccessScopeAnalysesCommandInput, DescribeNetworkInsightsAccessScopeAnalysesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeNetworkInsightsAccessScopeAnalysesCommandInput;
    constructor(input: DescribeNetworkInsightsAccessScopeAnalysesCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeNetworkInsightsAccessScopeAnalysesCommandInput, DescribeNetworkInsightsAccessScopeAnalysesCommandOutput>;
    private serialize;
    private deserialize;
}
