import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteIpamScopeRequest, DeleteIpamScopeResult } from "../models/models_2";
export interface DeleteIpamScopeCommandInput extends DeleteIpamScopeRequest {
}
export interface DeleteIpamScopeCommandOutput extends DeleteIpamScopeResult, __MetadataBearer {
}
/**
 * <p>Delete the scope for an IPAM. You cannot delete the default scopes.</p>
 *          <p>For more information, see <a href="/vpc/latest/ipam/delete-scope-ipam.html">Delete a scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteIpamScopeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteIpamScopeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteIpamScopeCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteIpamScopeCommandInput} for command's `input` shape.
 * @see {@link DeleteIpamScopeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteIpamScopeCommand extends $Command<DeleteIpamScopeCommandInput, DeleteIpamScopeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteIpamScopeCommandInput;
    constructor(input: DeleteIpamScopeCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteIpamScopeCommandInput, DeleteIpamScopeCommandOutput>;
    private serialize;
    private deserialize;
}
