import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreatePublicIpv4PoolRequest, CreatePublicIpv4PoolResult } from "../models/models_1";
export interface CreatePublicIpv4PoolCommandInput extends CreatePublicIpv4PoolRequest {
}
export interface CreatePublicIpv4PoolCommandOutput extends CreatePublicIpv4PoolResult, __MetadataBearer {
}
/**
 * <p>Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html">DescribePublicIpv4Pools</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreatePublicIpv4PoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreatePublicIpv4PoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreatePublicIpv4PoolCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreatePublicIpv4PoolCommandInput} for command's `input` shape.
 * @see {@link CreatePublicIpv4PoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreatePublicIpv4PoolCommand extends $Command<CreatePublicIpv4PoolCommandInput, CreatePublicIpv4PoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreatePublicIpv4PoolCommandInput;
    constructor(input: CreatePublicIpv4PoolCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreatePublicIpv4PoolCommandInput, CreatePublicIpv4PoolCommandOutput>;
    private serialize;
    private deserialize;
}
