import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UnmonitorInstancesRequest, UnmonitorInstancesResult } from "../models/models_6";
import { deserializeAws_ec2UnmonitorInstancesCommand, serializeAws_ec2UnmonitorInstancesCommand, } from "../protocols/Aws_ec2";
var UnmonitorInstancesCommand = (function (_super) {
    __extends(UnmonitorInstancesCommand, _super);
    function UnmonitorInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    UnmonitorInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "UnmonitorInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: UnmonitorInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: UnmonitorInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    UnmonitorInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2UnmonitorInstancesCommand(input, context);
    };
    UnmonitorInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2UnmonitorInstancesCommand(output, context);
    };
    return UnmonitorInstancesCommand;
}($Command));
export { UnmonitorInstancesCommand };
