import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { StartNetworkInsightsAnalysisRequest, StartNetworkInsightsAnalysisResult } from "../models/models_6";
import { deserializeAws_ec2StartNetworkInsightsAnalysisCommand, serializeAws_ec2StartNetworkInsightsAnalysisCommand, } from "../protocols/Aws_ec2";
var StartNetworkInsightsAnalysisCommand = (function (_super) {
    __extends(StartNetworkInsightsAnalysisCommand, _super);
    function StartNetworkInsightsAnalysisCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    StartNetworkInsightsAnalysisCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "StartNetworkInsightsAnalysisCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: StartNetworkInsightsAnalysisRequest.filterSensitiveLog,
            outputFilterSensitiveLog: StartNetworkInsightsAnalysisResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    StartNetworkInsightsAnalysisCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2StartNetworkInsightsAnalysisCommand(input, context);
    };
    StartNetworkInsightsAnalysisCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2StartNetworkInsightsAnalysisCommand(output, context);
    };
    return StartNetworkInsightsAnalysisCommand;
}($Command));
export { StartNetworkInsightsAnalysisCommand };
