import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { StartNetworkInsightsAccessScopeAnalysisRequest, StartNetworkInsightsAccessScopeAnalysisResult, } from "../models/models_6";
import { deserializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommand, serializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommand, } from "../protocols/Aws_ec2";
var StartNetworkInsightsAccessScopeAnalysisCommand = (function (_super) {
    __extends(StartNetworkInsightsAccessScopeAnalysisCommand, _super);
    function StartNetworkInsightsAccessScopeAnalysisCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    StartNetworkInsightsAccessScopeAnalysisCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "StartNetworkInsightsAccessScopeAnalysisCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: StartNetworkInsightsAccessScopeAnalysisRequest.filterSensitiveLog,
            outputFilterSensitiveLog: StartNetworkInsightsAccessScopeAnalysisResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    StartNetworkInsightsAccessScopeAnalysisCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommand(input, context);
    };
    StartNetworkInsightsAccessScopeAnalysisCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommand(output, context);
    };
    return StartNetworkInsightsAccessScopeAnalysisCommand;
}($Command));
export { StartNetworkInsightsAccessScopeAnalysisCommand };
