import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { StartInstancesRequest, StartInstancesResult } from "../models/models_6";
import { deserializeAws_ec2StartInstancesCommand, serializeAws_ec2StartInstancesCommand } from "../protocols/Aws_ec2";
var StartInstancesCommand = (function (_super) {
    __extends(StartInstancesCommand, _super);
    function StartInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    StartInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "StartInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: StartInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: StartInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    StartInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2StartInstancesCommand(input, context);
    };
    StartInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2StartInstancesCommand(output, context);
    };
    return StartInstancesCommand;
}($Command));
export { StartInstancesCommand };
