import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SendDiagnosticInterruptRequest } from "../models/models_6";
import { deserializeAws_ec2SendDiagnosticInterruptCommand, serializeAws_ec2SendDiagnosticInterruptCommand, } from "../protocols/Aws_ec2";
var SendDiagnosticInterruptCommand = (function (_super) {
    __extends(SendDiagnosticInterruptCommand, _super);
    function SendDiagnosticInterruptCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    SendDiagnosticInterruptCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "SendDiagnosticInterruptCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: SendDiagnosticInterruptRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    SendDiagnosticInterruptCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2SendDiagnosticInterruptCommand(input, context);
    };
    SendDiagnosticInterruptCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2SendDiagnosticInterruptCommand(output, context);
    };
    return SendDiagnosticInterruptCommand;
}($Command));
export { SendDiagnosticInterruptCommand };
