import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RunScheduledInstancesRequest, RunScheduledInstancesResult } from "../models/models_6";
import { deserializeAws_ec2RunScheduledInstancesCommand, serializeAws_ec2RunScheduledInstancesCommand, } from "../protocols/Aws_ec2";
var RunScheduledInstancesCommand = (function (_super) {
    __extends(RunScheduledInstancesCommand, _super);
    function RunScheduledInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RunScheduledInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RunScheduledInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RunScheduledInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RunScheduledInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RunScheduledInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RunScheduledInstancesCommand(input, context);
    };
    RunScheduledInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RunScheduledInstancesCommand(output, context);
    };
    return RunScheduledInstancesCommand;
}($Command));
export { RunScheduledInstancesCommand };
