import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RestoreSnapshotFromRecycleBinRequest, RestoreSnapshotFromRecycleBinResult } from "../models/models_5";
import { deserializeAws_ec2RestoreSnapshotFromRecycleBinCommand, serializeAws_ec2RestoreSnapshotFromRecycleBinCommand, } from "../protocols/Aws_ec2";
var RestoreSnapshotFromRecycleBinCommand = (function (_super) {
    __extends(RestoreSnapshotFromRecycleBinCommand, _super);
    function RestoreSnapshotFromRecycleBinCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RestoreSnapshotFromRecycleBinCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RestoreSnapshotFromRecycleBinCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RestoreSnapshotFromRecycleBinRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RestoreSnapshotFromRecycleBinResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RestoreSnapshotFromRecycleBinCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RestoreSnapshotFromRecycleBinCommand(input, context);
    };
    RestoreSnapshotFromRecycleBinCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RestoreSnapshotFromRecycleBinCommand(output, context);
    };
    return RestoreSnapshotFromRecycleBinCommand;
}($Command));
export { RestoreSnapshotFromRecycleBinCommand };
