import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetNetworkInterfaceAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ResetNetworkInterfaceAttributeCommand, serializeAws_ec2ResetNetworkInterfaceAttributeCommand, } from "../protocols/Aws_ec2";
var ResetNetworkInterfaceAttributeCommand = (function (_super) {
    __extends(ResetNetworkInterfaceAttributeCommand, _super);
    function ResetNetworkInterfaceAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetNetworkInterfaceAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetNetworkInterfaceAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetNetworkInterfaceAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetNetworkInterfaceAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetNetworkInterfaceAttributeCommand(input, context);
    };
    ResetNetworkInterfaceAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetNetworkInterfaceAttributeCommand(output, context);
    };
    return ResetNetworkInterfaceAttributeCommand;
}($Command));
export { ResetNetworkInterfaceAttributeCommand };
