import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetEbsDefaultKmsKeyIdRequest, ResetEbsDefaultKmsKeyIdResult } from "../models/models_5";
import { deserializeAws_ec2ResetEbsDefaultKmsKeyIdCommand, serializeAws_ec2ResetEbsDefaultKmsKeyIdCommand, } from "../protocols/Aws_ec2";
var ResetEbsDefaultKmsKeyIdCommand = (function (_super) {
    __extends(ResetEbsDefaultKmsKeyIdCommand, _super);
    function ResetEbsDefaultKmsKeyIdCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetEbsDefaultKmsKeyIdCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetEbsDefaultKmsKeyIdCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetEbsDefaultKmsKeyIdRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ResetEbsDefaultKmsKeyIdResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetEbsDefaultKmsKeyIdCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetEbsDefaultKmsKeyIdCommand(input, context);
    };
    ResetEbsDefaultKmsKeyIdCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetEbsDefaultKmsKeyIdCommand(output, context);
    };
    return ResetEbsDefaultKmsKeyIdCommand;
}($Command));
export { ResetEbsDefaultKmsKeyIdCommand };
