import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RequestSpotInstancesRequest, RequestSpotInstancesResult } from "../models/models_5";
import { deserializeAws_ec2RequestSpotInstancesCommand, serializeAws_ec2RequestSpotInstancesCommand, } from "../protocols/Aws_ec2";
var RequestSpotInstancesCommand = (function (_super) {
    __extends(RequestSpotInstancesCommand, _super);
    function RequestSpotInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RequestSpotInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RequestSpotInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RequestSpotInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RequestSpotInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RequestSpotInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RequestSpotInstancesCommand(input, context);
    };
    RequestSpotInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RequestSpotInstancesCommand(output, context);
    };
    return RequestSpotInstancesCommand;
}($Command));
export { RequestSpotInstancesCommand };
