import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReportInstanceStatusRequest } from "../models/models_5";
import { deserializeAws_ec2ReportInstanceStatusCommand, serializeAws_ec2ReportInstanceStatusCommand, } from "../protocols/Aws_ec2";
var ReportInstanceStatusCommand = (function (_super) {
    __extends(ReportInstanceStatusCommand, _super);
    function ReportInstanceStatusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReportInstanceStatusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReportInstanceStatusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReportInstanceStatusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReportInstanceStatusCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReportInstanceStatusCommand(input, context);
    };
    ReportInstanceStatusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReportInstanceStatusCommand(output, context);
    };
    return ReportInstanceStatusCommand;
}($Command));
export { ReportInstanceStatusCommand };
