import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReplaceTransitGatewayRouteRequest, ReplaceTransitGatewayRouteResult } from "../models/models_5";
import { deserializeAws_ec2ReplaceTransitGatewayRouteCommand, serializeAws_ec2ReplaceTransitGatewayRouteCommand, } from "../protocols/Aws_ec2";
var ReplaceTransitGatewayRouteCommand = (function (_super) {
    __extends(ReplaceTransitGatewayRouteCommand, _super);
    function ReplaceTransitGatewayRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReplaceTransitGatewayRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReplaceTransitGatewayRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReplaceTransitGatewayRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReplaceTransitGatewayRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReplaceTransitGatewayRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReplaceTransitGatewayRouteCommand(input, context);
    };
    ReplaceTransitGatewayRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReplaceTransitGatewayRouteCommand(output, context);
    };
    return ReplaceTransitGatewayRouteCommand;
}($Command));
export { ReplaceTransitGatewayRouteCommand };
