import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReplaceRouteTableAssociationRequest, ReplaceRouteTableAssociationResult } from "../models/models_5";
import { deserializeAws_ec2ReplaceRouteTableAssociationCommand, serializeAws_ec2ReplaceRouteTableAssociationCommand, } from "../protocols/Aws_ec2";
var ReplaceRouteTableAssociationCommand = (function (_super) {
    __extends(ReplaceRouteTableAssociationCommand, _super);
    function ReplaceRouteTableAssociationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReplaceRouteTableAssociationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReplaceRouteTableAssociationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReplaceRouteTableAssociationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReplaceRouteTableAssociationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReplaceRouteTableAssociationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReplaceRouteTableAssociationCommand(input, context);
    };
    ReplaceRouteTableAssociationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReplaceRouteTableAssociationCommand(output, context);
    };
    return ReplaceRouteTableAssociationCommand;
}($Command));
export { ReplaceRouteTableAssociationCommand };
