import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReplaceNetworkAclAssociationRequest, ReplaceNetworkAclAssociationResult } from "../models/models_5";
import { deserializeAws_ec2ReplaceNetworkAclAssociationCommand, serializeAws_ec2ReplaceNetworkAclAssociationCommand, } from "../protocols/Aws_ec2";
var ReplaceNetworkAclAssociationCommand = (function (_super) {
    __extends(ReplaceNetworkAclAssociationCommand, _super);
    function ReplaceNetworkAclAssociationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReplaceNetworkAclAssociationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReplaceNetworkAclAssociationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReplaceNetworkAclAssociationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReplaceNetworkAclAssociationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReplaceNetworkAclAssociationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReplaceNetworkAclAssociationCommand(input, context);
    };
    ReplaceNetworkAclAssociationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReplaceNetworkAclAssociationCommand(output, context);
    };
    return ReplaceNetworkAclAssociationCommand;
}($Command));
export { ReplaceNetworkAclAssociationCommand };
