import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReleaseHostsRequest, ReleaseHostsResult } from "../models/models_5";
import { deserializeAws_ec2ReleaseHostsCommand, serializeAws_ec2ReleaseHostsCommand } from "../protocols/Aws_ec2";
var ReleaseHostsCommand = (function (_super) {
    __extends(ReleaseHostsCommand, _super);
    function ReleaseHostsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReleaseHostsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReleaseHostsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReleaseHostsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReleaseHostsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReleaseHostsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReleaseHostsCommand(input, context);
    };
    ReleaseHostsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReleaseHostsCommand(output, context);
    };
    return ReleaseHostsCommand;
}($Command));
export { ReleaseHostsCommand };
