import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RegisterTransitGatewayMulticastGroupSourcesRequest, RegisterTransitGatewayMulticastGroupSourcesResult, } from "../models/models_5";
import { deserializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommand, serializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommand, } from "../protocols/Aws_ec2";
var RegisterTransitGatewayMulticastGroupSourcesCommand = (function (_super) {
    __extends(RegisterTransitGatewayMulticastGroupSourcesCommand, _super);
    function RegisterTransitGatewayMulticastGroupSourcesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RegisterTransitGatewayMulticastGroupSourcesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RegisterTransitGatewayMulticastGroupSourcesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RegisterTransitGatewayMulticastGroupSourcesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RegisterTransitGatewayMulticastGroupSourcesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RegisterTransitGatewayMulticastGroupSourcesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommand(input, context);
    };
    RegisterTransitGatewayMulticastGroupSourcesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommand(output, context);
    };
    return RegisterTransitGatewayMulticastGroupSourcesCommand;
}($Command));
export { RegisterTransitGatewayMulticastGroupSourcesCommand };
