import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { MoveAddressToVpcRequest, MoveAddressToVpcResult } from "../models/models_5";
import { deserializeAws_ec2MoveAddressToVpcCommand, serializeAws_ec2MoveAddressToVpcCommand, } from "../protocols/Aws_ec2";
var MoveAddressToVpcCommand = (function (_super) {
    __extends(MoveAddressToVpcCommand, _super);
    function MoveAddressToVpcCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    MoveAddressToVpcCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "MoveAddressToVpcCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: MoveAddressToVpcRequest.filterSensitiveLog,
            outputFilterSensitiveLog: MoveAddressToVpcResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    MoveAddressToVpcCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2MoveAddressToVpcCommand(input, context);
    };
    MoveAddressToVpcCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2MoveAddressToVpcCommand(output, context);
    };
    return MoveAddressToVpcCommand;
}($Command));
export { MoveAddressToVpcCommand };
