import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpnTunnelOptionsRequest, ModifyVpnTunnelOptionsResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpnTunnelOptionsCommand, serializeAws_ec2ModifyVpnTunnelOptionsCommand, } from "../protocols/Aws_ec2";
var ModifyVpnTunnelOptionsCommand = (function (_super) {
    __extends(ModifyVpnTunnelOptionsCommand, _super);
    function ModifyVpnTunnelOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpnTunnelOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpnTunnelOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpnTunnelOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpnTunnelOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpnTunnelOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpnTunnelOptionsCommand(input, context);
    };
    ModifyVpnTunnelOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpnTunnelOptionsCommand(output, context);
    };
    return ModifyVpnTunnelOptionsCommand;
}($Command));
export { ModifyVpnTunnelOptionsCommand };
