import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpnConnectionRequest, ModifyVpnConnectionResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpnConnectionCommand, serializeAws_ec2ModifyVpnConnectionCommand, } from "../protocols/Aws_ec2";
var ModifyVpnConnectionCommand = (function (_super) {
    __extends(ModifyVpnConnectionCommand, _super);
    function ModifyVpnConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpnConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpnConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpnConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpnConnectionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpnConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpnConnectionCommand(input, context);
    };
    ModifyVpnConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpnConnectionCommand(output, context);
    };
    return ModifyVpnConnectionCommand;
}($Command));
export { ModifyVpnConnectionCommand };
