import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcTenancyRequest, ModifyVpcTenancyResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcTenancyCommand, serializeAws_ec2ModifyVpcTenancyCommand, } from "../protocols/Aws_ec2";
var ModifyVpcTenancyCommand = (function (_super) {
    __extends(ModifyVpcTenancyCommand, _super);
    function ModifyVpcTenancyCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcTenancyCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcTenancyCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcTenancyRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpcTenancyResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcTenancyCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcTenancyCommand(input, context);
    };
    ModifyVpcTenancyCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcTenancyCommand(output, context);
    };
    return ModifyVpcTenancyCommand;
}($Command));
export { ModifyVpcTenancyCommand };
