import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcEndpointConnectionNotificationRequest, ModifyVpcEndpointConnectionNotificationResult, } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcEndpointConnectionNotificationCommand, serializeAws_ec2ModifyVpcEndpointConnectionNotificationCommand, } from "../protocols/Aws_ec2";
var ModifyVpcEndpointConnectionNotificationCommand = (function (_super) {
    __extends(ModifyVpcEndpointConnectionNotificationCommand, _super);
    function ModifyVpcEndpointConnectionNotificationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcEndpointConnectionNotificationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcEndpointConnectionNotificationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcEndpointConnectionNotificationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpcEndpointConnectionNotificationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcEndpointConnectionNotificationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcEndpointConnectionNotificationCommand(input, context);
    };
    ModifyVpcEndpointConnectionNotificationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcEndpointConnectionNotificationCommand(output, context);
    };
    return ModifyVpcEndpointConnectionNotificationCommand;
}($Command));
export { ModifyVpcEndpointConnectionNotificationCommand };
