import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyTransitGatewayVpcAttachmentRequest, ModifyTransitGatewayVpcAttachmentResult } from "../models/models_5";
import { deserializeAws_ec2ModifyTransitGatewayVpcAttachmentCommand, serializeAws_ec2ModifyTransitGatewayVpcAttachmentCommand, } from "../protocols/Aws_ec2";
var ModifyTransitGatewayVpcAttachmentCommand = (function (_super) {
    __extends(ModifyTransitGatewayVpcAttachmentCommand, _super);
    function ModifyTransitGatewayVpcAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyTransitGatewayVpcAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyTransitGatewayVpcAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyTransitGatewayVpcAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyTransitGatewayVpcAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyTransitGatewayVpcAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyTransitGatewayVpcAttachmentCommand(input, context);
    };
    ModifyTransitGatewayVpcAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyTransitGatewayVpcAttachmentCommand(output, context);
    };
    return ModifyTransitGatewayVpcAttachmentCommand;
}($Command));
export { ModifyTransitGatewayVpcAttachmentCommand };
