import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyTransitGatewayPrefixListReferenceRequest, ModifyTransitGatewayPrefixListReferenceResult, } from "../models/models_5";
import { deserializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommand, serializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommand, } from "../protocols/Aws_ec2";
var ModifyTransitGatewayPrefixListReferenceCommand = (function (_super) {
    __extends(ModifyTransitGatewayPrefixListReferenceCommand, _super);
    function ModifyTransitGatewayPrefixListReferenceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyTransitGatewayPrefixListReferenceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyTransitGatewayPrefixListReferenceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyTransitGatewayPrefixListReferenceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyTransitGatewayPrefixListReferenceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyTransitGatewayPrefixListReferenceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommand(input, context);
    };
    ModifyTransitGatewayPrefixListReferenceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommand(output, context);
    };
    return ModifyTransitGatewayPrefixListReferenceCommand;
}($Command));
export { ModifyTransitGatewayPrefixListReferenceCommand };
