import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyTransitGatewayRequest, ModifyTransitGatewayResult } from "../models/models_5";
import { deserializeAws_ec2ModifyTransitGatewayCommand, serializeAws_ec2ModifyTransitGatewayCommand, } from "../protocols/Aws_ec2";
var ModifyTransitGatewayCommand = (function (_super) {
    __extends(ModifyTransitGatewayCommand, _super);
    function ModifyTransitGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyTransitGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyTransitGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyTransitGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyTransitGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyTransitGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyTransitGatewayCommand(input, context);
    };
    ModifyTransitGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyTransitGatewayCommand(output, context);
    };
    return ModifyTransitGatewayCommand;
}($Command));
export { ModifyTransitGatewayCommand };
