import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyPrivateDnsNameOptionsRequest, ModifyPrivateDnsNameOptionsResult } from "../models/models_5";
import { deserializeAws_ec2ModifyPrivateDnsNameOptionsCommand, serializeAws_ec2ModifyPrivateDnsNameOptionsCommand, } from "../protocols/Aws_ec2";
var ModifyPrivateDnsNameOptionsCommand = (function (_super) {
    __extends(ModifyPrivateDnsNameOptionsCommand, _super);
    function ModifyPrivateDnsNameOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyPrivateDnsNameOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyPrivateDnsNameOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyPrivateDnsNameOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyPrivateDnsNameOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyPrivateDnsNameOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyPrivateDnsNameOptionsCommand(input, context);
    };
    ModifyPrivateDnsNameOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyPrivateDnsNameOptionsCommand(output, context);
    };
    return ModifyPrivateDnsNameOptionsCommand;
}($Command));
export { ModifyPrivateDnsNameOptionsCommand };
