import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstanceMetadataOptionsRequest, ModifyInstanceMetadataOptionsResult } from "../models/models_5";
import { deserializeAws_ec2ModifyInstanceMetadataOptionsCommand, serializeAws_ec2ModifyInstanceMetadataOptionsCommand, } from "../protocols/Aws_ec2";
var ModifyInstanceMetadataOptionsCommand = (function (_super) {
    __extends(ModifyInstanceMetadataOptionsCommand, _super);
    function ModifyInstanceMetadataOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstanceMetadataOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstanceMetadataOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstanceMetadataOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyInstanceMetadataOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstanceMetadataOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstanceMetadataOptionsCommand(input, context);
    };
    ModifyInstanceMetadataOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstanceMetadataOptionsCommand(output, context);
    };
    return ModifyInstanceMetadataOptionsCommand;
}($Command));
export { ModifyInstanceMetadataOptionsCommand };
