import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyImageAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyImageAttributeCommand, serializeAws_ec2ModifyImageAttributeCommand, } from "../protocols/Aws_ec2";
var ModifyImageAttributeCommand = (function (_super) {
    __extends(ModifyImageAttributeCommand, _super);
    function ModifyImageAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyImageAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyImageAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyImageAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyImageAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyImageAttributeCommand(input, context);
    };
    ModifyImageAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyImageAttributeCommand(output, context);
    };
    return ModifyImageAttributeCommand;
}($Command));
export { ModifyImageAttributeCommand };
