import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyIdentityIdFormatRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyIdentityIdFormatCommand, serializeAws_ec2ModifyIdentityIdFormatCommand, } from "../protocols/Aws_ec2";
var ModifyIdentityIdFormatCommand = (function (_super) {
    __extends(ModifyIdentityIdFormatCommand, _super);
    function ModifyIdentityIdFormatCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyIdentityIdFormatCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyIdentityIdFormatCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyIdentityIdFormatRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyIdentityIdFormatCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyIdentityIdFormatCommand(input, context);
    };
    ModifyIdentityIdFormatCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyIdentityIdFormatCommand(output, context);
    };
    return ModifyIdentityIdFormatCommand;
}($Command));
export { ModifyIdentityIdFormatCommand };
