import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyHostsRequest, ModifyHostsResult } from "../models/models_5";
import { deserializeAws_ec2ModifyHostsCommand, serializeAws_ec2ModifyHostsCommand } from "../protocols/Aws_ec2";
var ModifyHostsCommand = (function (_super) {
    __extends(ModifyHostsCommand, _super);
    function ModifyHostsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyHostsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyHostsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyHostsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyHostsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyHostsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyHostsCommand(input, context);
    };
    ModifyHostsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyHostsCommand(output, context);
    };
    return ModifyHostsCommand;
}($Command));
export { ModifyHostsCommand };
