import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListSnapshotsInRecycleBinRequest, ListSnapshotsInRecycleBinResult } from "../models/models_5";
import { deserializeAws_ec2ListSnapshotsInRecycleBinCommand, serializeAws_ec2ListSnapshotsInRecycleBinCommand, } from "../protocols/Aws_ec2";
var ListSnapshotsInRecycleBinCommand = (function (_super) {
    __extends(ListSnapshotsInRecycleBinCommand, _super);
    function ListSnapshotsInRecycleBinCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListSnapshotsInRecycleBinCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ListSnapshotsInRecycleBinCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListSnapshotsInRecycleBinRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListSnapshotsInRecycleBinResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListSnapshotsInRecycleBinCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ListSnapshotsInRecycleBinCommand(input, context);
    };
    ListSnapshotsInRecycleBinCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ListSnapshotsInRecycleBinCommand(output, context);
    };
    return ListSnapshotsInRecycleBinCommand;
}($Command));
export { ListSnapshotsInRecycleBinCommand };
